package com.beiming.odr.document.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 签名请求的基础信息参数(带文件)
 * 
 * @author DJQ
 *
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = false)
public class SignatureInfoWithFileReqDTO extends SignatureInfoReqDTO implements Serializable {

  private static final long serialVersionUID = -2185513732200103145L;

  @NotEmpty(message = "文件名称不能为空")
  private String fileName;

  @NotNull(message = "文件BYTES不能为空")
  private byte[] fileByte;

  public SignatureInfoWithFileReqDTO(Long userId, String imgId, Integer degree,
      List<SignatureBizInfoReqDTO> signBizInfo) {
    super(userId, imgId, degree, signBizInfo);
    // TODO Auto-generated constructor stub
  }

  public SignatureInfoWithFileReqDTO(SignatureInfoReqDTO signInfoReq,
      @NotEmpty(message = "业务信息参数为空") List<SignatureBizInfoReqDTO> signBizInfo) {
    super(signInfoReq, signBizInfo);
    // TODO Auto-generated constructor stub
  }

  public SignatureInfoWithFileReqDTO(@Valid SignatureInfoReqDTO signInfoReq,
      @NotNull(message = "业务信息参数为空") SignatureBizInfoReqDTO bizInfo) {
    super(signInfoReq, bizInfo);
    // TODO Auto-generated constructor stub
  }
  
}
