package com.beiming.odr.document.dto.requestdto;

import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description: 保存文件请求参数
 * @Author: caiwei
 * @Date: 2019/3/1
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class UploadFileReqDTO implements Serializable {

  private static final long serialVersionUID = 2175799831402724755L;

  /**
   * 调解室id/案件id
   */
  private Long objectId;

  /**
   * 调解室/案件
   */
  private String objectType;

  /**
   * 会议id
   */
  private Long meetingId;

  /**
   * 附件大分类
   */
  private String categoryBig;

  /**
   * 附件中分类
   */
  private String categoryMiddle;

  /**
   * 附件小分类(备用)
   */
  private String categorySmall;

  /**
   * 文书类型
   */
  private String sign;

  /**
   * 文件id
   */
  private String fileId;

  /**
   * 文件名称
   */
  private String fileName;

  /**
   * 创建者id
   */
  private Long userId;

  /**
   * 创建者
   */
  private String createUser;

  /**
   * 更新者
   */
  private String updateUser;

}