package com.beiming.odr.document.dto.responsedto;

import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description: 代理人信息返回实体类
 * @Author: caiwei
 * @Date: 2019/2/26
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class AgentInfoResDTO implements Serializable {

  private static final long serialVersionUID = 4715011664764298788L;
  /**
   * 人员id
   */
  private Long agentPersonId;

  /**
   * 代理人id
   */
  private Long agentId;

  /**
   * 代理人案件类型（申请人代理人、被申请人代理）
   */
  private String caseUserType;

  /**
   * 代理人类型（一般代理人，特权代理人）
   */
  private String agentType;

  /**
   * 代理人姓名
   */
  private String agentName;

  /**
   * 代理人性别
   */
  private String agentSex;

  /**
   * 代理人联系电话
   */
  private String agentPhone;

  /**
   * 代理人身份证号
   */
  private String agentIdCard;

  /**
   * 代理人固定电话
   */
  private String agentTelephone;
}