package com.beiming.odr.document.dto.responsedto;

import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description: 仲裁协议书返回实体类
 * @Author: caiwei
 * @Date: 2019/2/26
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ArbitrationBookResDTO implements Serializable {

  private static final long serialVersionUID = 6845558320970291756L;

  /**
   * 仲裁协议书id
   */
  private Long arbitrationBookId;

  /**
   * 调解室id/案件id
   */
  private Long objectId;

  /**
   * 编号
   */
  private String caseNo;

  /**
   * 机构ID
   */
  private Long orgId;

  /**
   * 机构名称
   */
  private String orgName;

  /**
   * 纠纷类型
   */
  private String disputeType;

  /**
   * 申请方
   */
  private List<DocPersonResDTO> applicantList;

  /**
   * 申请方代理人
   */
  private List<DocPersonResDTO> appAgentList;

  /**
   * 被申请方
   */
  private List<DocPersonResDTO> respondentList;

  /**
   * 被申请方代理人
   */
  private List<DocPersonResDTO> resAgentList;

  /**
   * 工作人员
   */
  private List<DocPersonResDTO> staffList;

  /**
   * 经调解，自愿达成如下协议
   */
  private String content;

  /**
   * 协议是否发送
   */
  private String sendStatus;

  /**
   * 相关人员签名详情
   */
  private List<DocPersonConfirmResDTO> confirmList;
}
