package com.beiming.odr.document.dto.responsedto;

import java.io.Serializable;
import java.util.Date;

import com.beiming.framework.util.Date2LongSerialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 附件返回值
 * 
 * @author qsh
 * @date 2019年2月27日
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class DocAttachmentResDTO implements Serializable {
  private static final long serialVersionUID = 1L;

  private Long id;
  /**
   * 类型
   */
  private String objectType;

  /**
   * 对应表主键id
   */
  private Long objectId;

  /**
   * 文书id
   */
  private Long docId;

  /**
   * 文件名
   */
  private String fileName;

  /**
   * 文件fileId
   */
  private String fileId;

  /**
   * 上传者id
   */
  private Long personnelId;

  /**
   * 案件人员id
   */
  private Long caseUserId;
  
  /**
   * 附件大分类( 调解用，诉讼用，司法确认用等)
   */
  private String categoryBig;

  /**
   * 附件中分类(书证、物证、等等)
   */
  private String categoryMiddle;

  /**
   * 附件小分类(备用)
   */
  private String categorySmall;

  /**
   * 当类型为书证时(默认附件,调谐协议书,调解笔录,调查笔录,司法确认申请书,调解申请书,当事人权利义务告知书,授权委托书,调解协议履行证明,调解回访记录,结案表)
   */
  private String sign;

  /**
   * 会议Id
   */
  private Long meetingId;

  /**
   * 预览url
   */
  private String previewUrl;
  
  /**
   * 生成记录的人员Name
   */
  private String createUser;

  /**
   * 是否签属过文书
   */
  private String confirmFlag;

  /**
   * 房间id
   */
  private String roomId;
  
  /**
   * 文书模板备注
   */
  private String docTemplateRemark;

  /**
   * doc_attachment表中的备注（remark字段）
   */
  private String docRemark;


  private String signStr;
  @JsonSerialize(using = Date2LongSerialize.class)
  private Date createTime;

  /**
   * 是否审核
   * */
  private String examineFlag;


}
