package com.beiming.odr.document.dto.responsedto;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description: 文书人员信息返回实体类
 * @Author: caiwei
 * @Date: 2019/2/26 0026
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DocPersonResDTO implements Serializable {

  private static final long serialVersionUID = -3299590246742009824L;

  /**
   * 文书人员id
   */
  private Long personId;

  /**
   * 文书id
   */
  private Long docId;

  /**
   * 文书类型
   */
  private String docType;

  /**
   * 用户ID
   */
  private Long userId;

  /**
   * 案件用户类型
   */
  private String caseUserType;

  /**
   * 用户类型
   */
  private String userType;

  /**
   * 名称
   */
  private String userName;

  /**
   * 性别
   */
  private String sex;

  /**
   * 电话
   */
  private String phone;

  /**
   * 固定电话
   */
  private String telephone;

  /**
   * 身份证号
   */
  private String idCard;

  /**
   * 民族
   */
  private String nation;

  /**
   * 单位
   */
  private String company;

  /**
   * 出生日期
   */
  private Date birthday;

  /**
   * 信用代码
   */
  private String creditCode;

  /**
   * 法人代表
   */
  private String corporation;

  /**
   * 省份code
   */
  private String provCode;

  /**
   * 城市code
   */
  private String cityCode;

  /**
   * 区code
   */
  private String areaCode;

  /**
   * 街道code
   */
  private String streetCode;

  /**
   * 省份名称
   */
  private String provName;

  /**
   * 城市名称
   */
  private String cityName;

  /**
   * 区名称
   */
  private String areaName;

  /**
   * 街道名称
   */
  private String streetName;

  /**
   * 详细地址
   */
  private String address;

  /**
   * 排序
   */
  private Integer userOrder;

  /**
   * 代理人
   */
  private AgentInfoResDTO agent;
}