package com.beiming.odr.document.dto.responsedto;

import java.io.Serializable;
import lombok.Data;

/**
 * 文书人员
 * 
 * @author qsh
 * @date 2019年6月20日
 */
@Data
public class DocPersonnelResDTO implements Serializable {

  private static final long serialVersionUID = 1L;
  private Long id;
  /**
   * 对应表主键id
   */
  private Long objectId;

  /**
   * 调解室/案件
   */
  private String objectType;

  /**
   * 文书类型
   */
  private String docType;

  /**
   * 文书id
   */
  private Long docId;

  /**
   * 用户id
   */
  private Long userId;

  /**
   * 案件用户类型（申请人 ,被申请人, 调解员）
   */
  private String caseUserType;

  /**
   * 用户类型（自然人,法人,非法人组织）
   */
  private String userType;

  /**
   * 名称(类别为法人/非法人组织时, 填单位名称)
   */
  private String userName;


  /**
   * 联系电话
   */
  private String phone;



  /**
   * 详细地址
   */
  private String address;



  /**
   * 固定电话
   */
  private String telephone;

  /**
   * 送达地址确认书
   */
  private String docAddress;

  /**
   * @param id
   * @param objectId
   * @param objectType
   * @param docType
   * @param docId
   * @param userId
   * @param caseUserType
   * @param userType
   * @param userName
   * @param phone
   * @param idCard
   * @param address
   * @param telephone
   * @param docAddress
   * @param lawAttachmentId
   */
  public DocPersonnelResDTO(Long id, Long objectId, String objectType, String docType, Long docId,
      Long userId, String caseUserType, String userType, String userName, String phone,
      String address, String telephone, String docAddress) {
    super();
    this.id = id;
    this.objectId = objectId;
    this.objectType = objectType;
    this.docType = docType;
    this.docId = docId;
    this.userId = userId;
    this.caseUserType = caseUserType;
    this.userType = userType;
    this.userName = userName;
    this.phone = phone;
    this.address = address;
    this.telephone = telephone;
    this.docAddress = docAddress;
  }



}
