package com.beiming.odr.document.dto.responsedto;

import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 获取调解笔录的响应对象
 * 
 * @author DJQ 2018年6月26日
 *
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DocRecordGetResDTO implements Serializable {

  private static final long serialVersionUID = -5839195949001032307L;

  private Long docId; // ID
  private Long bizId; // 业务主体ID：案件ID
  private String bizType; // 业务主体类型：调解室，会议
  private String bizNo; // 业务主体编号：案件编号
  // private String disputeCode; // 纠纷code
  private String disputeType; // 纠纷类型
  private Long orgId; // 机构Id
  private String orgName; // 机构Name
  private String content; // 笔录内容
  private String sendStatus; // 是否已发送
  private String time; // 时间
  private String location; // 地点
  private String remark; // 备注

  private List<DocPersonalResDTO> docPersonals; // 会议参与人信息（调解员，自己存一份）

  /**
   * 用户信息  原告-张三-身份证... 微庭审使用
   */
  private String userInfo;

  /**
   * 选中的用户钩选关系,数据库保存为json串 微庭审使用
   */
  private String selectPersons;

  public DocRecordGetResDTO(Long bizId, String bizNo, String disputeType, Long orgId,
      String orgName, String time, String location) {
    super();
    this.bizId = bizId;
    this.bizNo = bizNo;
    this.disputeType = disputeType;
    this.orgId = orgId;
    this.orgName = orgName;
    this.time = time;
    this.location = location;
  }

}
