package com.beiming.odr.document.dto.responsedto;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * @ClassName DocTempListResDTO
 * @Description 租户管理返回列表信息
 * @author dongjunqing
 * @date Mar 6, 2020 3:27:13 PM
 *
 */
@Data
public class DocTempListResDTO implements Serializable {
  private static final long serialVersionUID = 1L;

  // 文书id
  private Long id;

  // 文书类别
  private String docType;
  
  // 文书名称
  private String docName;

  // 发布时间
  // @JsonSerialize(using = Date2LongSerialize.class)
  private Date publishTime;

  // 是否上架,0未使用1上架2下架", example = "2")
  private int onlineStatus;

  // 创建人", example = "张洒")
  private String createUser;
  
  /**
   * 文书模板备注
   */
  private String docTemplateRemark;

}
