package com.beiming.odr.document.dto.responsedto;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 文书确认
 * 
 * @author qsh
 * @date 2019年6月20日
 */
@Data
public class DocWholeConfirmResDTO implements Serializable {

  private static final long serialVersionUID = 1L;

  private Long id;
  /**
   * 确认者id
   */
  private Long confirmUserId;

  /**
   * 确认者姓名
   */
  private String confirmUserName;

  /**
   * 确认者身份（申请人，被申请人, 调解员）
   */
  private String confirmUserType;

  /**
   * 确认时间
   */
  private Date confirmTime;

  /**
   * 最终的确认状态
   */
  private String confirm;

  /**
   * 调解室/案件
   */
  private String objectType;

  /**
   * 对应表主键id
   */
  private Long objectId;

  /**
   * 文书类型（无争议事实,承诺书,无异议调解方案,调解协议书,视频）
   */
  private String docType;

  /**
   * 文书id
   */
  private Long docId;

  /**
   * 文书意见
   */
  private String docOpinion;
  
  /**
   * 签名地址
   */
  private String signatureUrl;
  
  /**
   * 版本
   */
  private Integer version;
  
  private String updateUser;
  
  private Integer status;

}
