package com.beiming.odr.document.dto.responsedto;

import java.io.Serializable;
import lombok.Data;

/**
 * @Author batman lin chen
 * @Date 2022/4/26 11:21
 * @Version 1.0
 */
@Data
public class DocumentRecordResDTO implements Serializable {

  /**
   * 申请人确认
   */
  private String applicantConfirm;

  /**
   * 被申请人确认
   */
  private String respondentConfirm;

  /**
   * 协助调解员确认
   */
  private String assistantConfirm;

  /**
   * 失败/成功确认
   */
  private String confirm;

  /**
   * 调解室/案件
   */
  private String objectType;

  /**
   * 对应表主键id
   */
  private Long objectId;

  /**
   * 文书类型（无争议事实承诺书,无异议调解方案,调解协议书,调解笔录）
   */
  private String docType;

  /**
   * 文档名称
   */
  private String docName;

  /**
   * 文件id
   */
  private String fileId;

  /**
   * 是否已发送
   */
  private String sendStatus;

  /**
   * 纠纷类型
   */
  private String disputeType;

  /**
   * 组织机构名字
   */
  private String orgName;

  /**
   * 案号
   */
  private String caseNo;

  /**
   *
   */
  private String extendType;

  /**
   * 会议ID
   */
  private Long meetingId;

  /**
   * 调解协议/调解方案/调解过程/争议事项
   */
  private String content;

  /**
   * 扩展字段
   */
  private String extendJson;

  /**
   * 机构id
   */
  private Long orgId;

  /**
   * 模板id
   */
  private Long docTempId;

  /**
   * 人员信息
   */
  private String userInfo;

  /**
   * 人员personId信息
   */
  private String selectPersons;
  /**
   * 分享的会议列表
   */
  private String shareMeetingId;

  /**
   * 房间id
   */
  private String roomId;
}
