package com.beiming.odr.document.dto.responsedto;

import java.io.Serializable;
import lombok.Data;

/**
 * 文书返回信息
 * 
 * @author qsh
 * @date 2019年6月20日
 */
@Data
public class DocumentResDTO implements Serializable {

  /**
   * 
   */
  public DocumentResDTO() {
    super();
    // TODO Auto-generated constructor stub
  }

  private static final long serialVersionUID = 1L;
  private Long id;
  /**
   * 申请人确认
   */
  private String applicantConfirm;

  /**
   * 被申请人确认
   */
  private String respondentConfirm;


  /**
   * 失败/成功确认
   */
  private String confirm;

  /**
   * 调解室/案件
   */
  private String objectType;

  /**
   * 对应表主键id
   */
  private Long objectId;

  /**
   * 文书类型（无争议事实承诺书,无异议调解方案,调解协议书,调解笔录）
   */
  private String docType;

  /**
   * 文档名称
   */
  private String docName;

  /**
   * 文件id
   */
  private String fileId;

  /**
   * 是否已发送
   */
  private String sendStatus;

  /**
   * 纠纷类型
   */
  private String disputeType;

  /**
   * @param id
   * @param applicantConfirm
   * @param respondentConfirm
   * @param confirm
   * @param objectType
   * @param objectId
   * @param docType
   * @param docName
   * @param fileId
   * @param sendStatus
   * @param disputeType
   */
  public DocumentResDTO(Long id, String applicantConfirm, String respondentConfirm, String confirm,
      String objectType, Long objectId, String docType, String docName, String fileId,
      String sendStatus, String disputeType) {
    super();
    this.id = id;
    this.applicantConfirm = applicantConfirm;
    this.respondentConfirm = respondentConfirm;
    this.confirm = confirm;
    this.objectType = objectType;
    this.objectId = objectId;
    this.docType = docType;
    this.docName = docName;
    this.fileId = fileId;
    this.sendStatus = sendStatus;
    this.disputeType = disputeType;
  }


}
