package com.beiming.odr.document.dto.responsedto;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author sunzheng
 * @date 2023/06/30
 */

/**
 * 卷宗材料表
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class DossierAttachment implements Serializable {

  private Long id;

  /**
   * 卷宗材料排序字段
   */
  private Integer docSort;

  /**
   * 状态
   */
  private Integer status;

  /**
   * 备注
   */
  private String remark;

  /**
   * 创建人名字
   */
  private String createUser;

  /**
   * 创建时间
   */
  private Date createTime;

  /**
   * 更新人名字
   */
  private String updateUser;

  /**
   * 更新时间
   */
  private Date updateTime;

  /**
   * 版本
   */
  private Integer version;

  /**
   * 文件名
   */
  private String fileName;

  /**
   * 文件格式类型
   */
  private String fileType;

  /**
   * 文件fileId
   */
  private String fileId;

  /**
   * 预览url
   */
  private String previewUrl;

  /**
   * 上传者id
   */
  private Long createUserId;

  /**
   * 附件大分类( 调解用，诉讼用，司法确认用等)
   */
  private String categoryBig;

  /**
   * 附件中分类(主体材料、起诉状、证据材料)
   */
  private String categoryMiddle;

  /**
   * 附件小分类(备用)
   */
  private String categorySmall;

  /**
   * 会议Id
   */
  private Long meetingId;

  /**
   * 房间id
   */
  private String roomId;

  private static final long serialVersionUID = -2789293786421792996L;
}