package com.beiming.odr.document.dto.responsedto;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author sunzheng
 * @date 2023/07/03
 */

/**
 * 电子送达表
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ElectronicDeliveryResDTO implements Serializable {

  private Long id;

  /**
   * 状态
   */
  private Integer status;

  /**
   * 签名状态：{SIGN_YES("已签名"), SIGN_NO("未签名")}
   */
  private String confirm;

  /**
   * 备注
   */
  private String remark;

  /**
   * 当事人姓名
   */
  private String userName;

  /**
   * 当事人id
   */
  private Long userId;

  /**
   * 签署人类型
   */
  private String confirmUserType;

  /**
   * 手机号
   */
  private String phone;

  /**
   * 其他联系方式
   */
  private String otherContactWay;

  /**
   * 手机号
   */
  private String email;

  /**
   * 省名称
   */
  private String provinceName;

  /**
   * 省代码
   */
  private String provinceCode;

  /**
   * 市名称
   */
  private String cityName;

  /**
   * 市代码
   */
  private String cityCode;

  /**
   * 区名称
   */
  private String areaName;

  /**
   * 区代码
   */
  private String areaCode;

  /**
   * 街道名称
   */
  private String streetName;

  /**
   * 街道代码
   */
  private String streetCode;

  /**
   * 详细地址
   */
  private String detailedAddress;

  /**
   * 创建时间
   */
  private Date createTime;

  /**
   * 更新时间
   */
  private Date updateTime;

  /**
   * 版本
   */
  private Integer version;

  /**
   * 文件fileId
   */
  private String fileId;

  /**
   * 预览url
   */
  private String previewUrl;

  /**
   * 当事人签名url
   */
  private String signatureUrl;

  /**
   * 会议Id
   */
  private Long meetingId;

  /**
   * 电子送达文档id
   */
  private Long docId;

  /**
   * 当前签署人id
   */
  private String currentUserId;

  /**
   * 签署二维码地址
   */
  private String launchSign;

  private static final long serialVersionUID = -7817871596877928930L;

}