package com.beiming.odr.document.dto.responsedto;

import java.io.Serializable;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 文书送达信息返回数据
 *
 * @author 滑翔的人儿
 * @date 2022/01/24
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class GzzcDocDeliveryResDTO implements Serializable {

  private static final long serialVersionUID = 1L;

  /**
   * 用户id
   */
  private Long userId;

  /**
   * 案件用户类型
   */
  private String caseUserType;

  /**
   * 用户姓名
   */
  private String userName;

  /**
   * 文书类型
   */
  private String docType;

  /**
   * 文书id
   */
  private Long docId;

  /**
   * 送达备注
   */
  private String remark;

  /**
   * 送达状态：1送达，0未送达
   */
  private String deliveryStatus;

  /**
   * 送达时间
   */
  private String sendTime;
}
