package com.beiming.odr.document.dto.responsedto;

import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description: 调解协议书返回实体类
 * @Author: caiwei
 * @Date: 2019/2/26
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MediationBookResDTO implements Serializable {

  private static final long serialVersionUID = 6845558320970291756L;

  /**
   * 调解协议书id
   */
  private Long mediationBookId;

  /**
   * 调解室id/案件id
   */
  private Long objectId;

  /**
   * 编号
   */
  private String caseNo;

  /**
   * 机构ID
   */
  private Long orgId;

  /**
   * 机构名称
   */
  private String orgName;

  /**
   * 纠纷类型
   */
  private String disputeType;

  /**
   * 申请方
   */
  private List<DocPersonResDTO> applicantList;

  /**
   * 被申请方
   */
  private List<DocPersonResDTO> respondentList;

  /**
   * 纠纷主要事实，争议事项
   */
  private String disputeContent;

  /**
   * 经调解，自愿达成如下协议
   */
  private String mediationContent;

  /**
   * 协议是否发送
   */
  private String sendStatus;

  // 相关人员签名详情
  private List<DocPersonConfirmResDTO> confirmList;

  // 协助调解员
  private List<MediatorHelpPersonResDTO> mediatorHelpPersonList;

}
