package com.beiming.odr.document.dto.responsedto;

import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description: 无异议调解方案返回实体类
 * @Author: caiwei
 * @Date: 2019/2/26
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MediationSchemeResDTO implements Serializable {

  private static final long serialVersionUID = 6845558320970291756L;

  /**
   * 无异议调解方案id
   */
  private Long mediationSchemeId;

  /**
   * 调解室id/案件id
   */
  private Long objectId;

  /**
   * 编号
   */
  private String caseNo;
  
  /**
   * 机构ID
   */
  private Long orgId;

  /**
   * 机构名称
   */
  private String orgName;

  /**
   * 纠纷类型
   */
  private String disputeType;

  /**
   * 申请方
   */
  private List<DocPersonResDTO> applicantList;

  /**
   * 被申请方
   */
  private List<DocPersonResDTO> respondentList;

  /**
   * 调解方案
   */
  private String mediationScheme;

  /**
   * 调解须知
   */
  private String mediationNeeds;

  /**
   * 协议是否发送
   */
  private String sendStatus;

  // 相关人员签名详情
  private List<DocPersonConfirmResDTO> confirmList;

  // 协助调解员
  private List<MediatorHelpPersonResDTO> mediatorHelpPersonList;
}