package com.beiming.odr.document.dto.responsedto;

import java.io.Serializable;
import java.util.List;
import com.beiming.odr.document.dto.SignatureBizInfoDTO;
import com.beiming.odr.document.dto.SyntheticDocumentMqDTO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class SignatureInfoResDTO implements Serializable {

  private static final long serialVersionUID = -1057959836990248318L;

  /**
   * 错误提示
   */
  private String errorMsg;

  /**
   * 电子送达回证所在的案件id
   */
  private Long meetingId;
  
  /**
   * 签名业务结果信息
   */
  private List<SignatureBizInfoDTO> signBizInfoLst;
  
  
  private List<SyntheticDocumentMqDTO> mqDtoList;

  public SignatureInfoResDTO(String errorMsg, List<SignatureBizInfoDTO> signBizInfoLst, List<SyntheticDocumentMqDTO> mqDtoList) {
    this.errorMsg = errorMsg;
    this.signBizInfoLst = signBizInfoLst;
    this.mqDtoList = mqDtoList;
  }
}
