package com.beiming.odr.document.dto.responsedto;

import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description: 无争议事实返回实体类
 * @Author: caiwei
 * @Date: 2019/2/26
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class UndisputedFactResDTO implements Serializable {

  private static final long serialVersionUID = 6845558320970291756L;

  /**
   * 无争议事实id
   */
  private Long undisputedFactId;

  /**
   * 调解室id/案件id
   */
  private Long objectId;

  /**
   * 编号
   */
  private String caseNo;
  
  /**
   * 机构Id
   */
  private Long orgId;

  /**
   * 机构名称
   */
  private String orgName;

  /**
   * 纠纷类型
   */
  private String disputeType;

  /**
   * 申请方
   */
  private List<DocPersonResDTO> applicantList;

  /**
   * 被申请方
   */
  private List<DocPersonResDTO> respondentList;

  /**
   * 调解过程
   */
  private String mediationProcess;

  /**
   * 无争议事实内容
   */
  private String undisputedFactContent;

  /**
   * 协议是否发送
   */
  private String sendStatus;

  // 相关人员签名详情
  private List<DocPersonConfirmResDTO> confirmList;

  // 协助调解员
  private List<MediatorHelpPersonResDTO> mediatorHelpPersonList;
}