package com.beiming.odr.document.dto.third.tdh.request;

import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;


@Data
@AllArgsConstructor
@NoArgsConstructor
@ToString
@Builder
public class MaterialsCallBackDto {

  //传递互联网案号到湖北数据中心。有数据中心替换ahdm
  private String  baah;

  //* 法院代码 – 法院代码，必须输入，法院代码使用最高人民法院规范代码，例如南京中院法院代码：1151
  private String fydm;
  //* 案件标识  必须输入
  private String ahdm;
  //  应用代码  调用方应用系统代码，如：华宇审判系统传HYSP
  private String yydm;

  //*  材料数据集合  必传
  private List<MaterialsDto> clList;
  //   是否实时入卷  是否实时入卷标识，为1时表示需要实时入卷，并返回入卷后的卷宗序号
  private String sfssrj;

  public MaterialsCallBackDto getNewMaterialsCallBackDto(Long fydm, String ah, Long ahdm,
      String yydm, List<MaterialsDto> materialList) {
    MaterialsCallBackDto dto = new MaterialsCallBackDto();
    dto.setBaah(ah);
//    dto.setBaah("（2023）鄂12民初48号");
    dto.setFydm(String.valueOf(fydm));
//    this.ahdm = String.valueOf(ahdm);
    dto.setYydm(yydm);
    dto.setSfssrj("1");
    dto.setClList(materialList);
    return dto;
  }
}