package com.beiming.odr.document.dto.third.tdh.request;

import com.beiming.odr.document.dto.responsedto.RecordAndMaterialResDTO;
import java.text.SimpleDateFormat;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;


@Data
@AllArgsConstructor
@NoArgsConstructor
@ToString
@Builder
public class MaterialsDto {

  //   材料来源ID  唯一ID，全局唯一，用于删除和更新
  private String cllyid;

  //*  排序号  必须输入 材料内部排序号，从1开始递增
  private String xh;
  //*  文件名称  必须输入 文件显示名称，不包括文件格式，例如：判决书，从1开始递增
  private String mc;
  //*  文件格式  必须输入 文件格式仅支持：txt,rtf,doc,docx,wps,pdf,jpg,png,bmp,tif,tiff,xls,xlsx
  private String wjgs;

  //   文件大小   txt,rtf,doc,docx,wps,xls,xlsx格式必须输入，以K为单位,单文件最大支持5M
  private String wjdx;

  //   文件页数   txt,rtf,doc,docx,wps格式必须输入

  private String wjys;

  //   文件字数   txt,rtf,doc,docx,wps格式必须输入
  private String wjzs;
  //   实体类别（代码）
  //15_000114-1 庭审材料（笔录、录音、录像等）
  //15_000114-2 证据材料（图片、录音、录像等）
  //15_000114-3 诉状材料（电子文档、扫描件等）
  //15_000114-4 鉴定材料（电子文档、扫描件等）
  //15_000114-5 勘验笔录（电子文档、扫描件等）
  //15_000114-6 公证材料（电子文档、扫描件等）
  //15_000114-7 仲裁材料（电子文档、扫描件等）
  //15_000114-8 文书材料（电子文档、扫描件等）
  //15_000114-255 其他
  //文件非doc格式时必传
  //注：具体传值请咨询卷宗研发或产品
  private String stlb;

  //   文书类别（代码）
  //15_000113-1 诉辩状
  //15_000113-2 传票
  //15_000113-3 通知书
  //15_000113-4 判决书
  //15_000113-5 裁定书
  //15_000113-6 调解书
  //15_000113-7 决定书
  //15_000113-8 笔录
  //15_000113-9 报告
  //15_000113-10 函
  //15_000113-11 证明书
  //15_000113-255 其他文书
  //例如：如果是判决书，请输入15_000113-4
  //文书类型必传
  //注：具体传值请咨询卷宗研发或产品
  private String wslb;

  //*   卷宗类别（原正副卷标识）  必须输入
  //*   正卷：z，副卷f，公安卷：g，检查卷：j，证据卷：e
  private String jzlb;

  //    是否完稿   是否完稿
  private String sfwg;

  //    是否定稿   是否定稿
  private String sfdg;

  //*   是否为URL类型   1表示是，其他否，必须输入
  private String sfurl;
  //    url       SFURL为1时必填
  private String url;
  //    互联网URL       SFURL为1时必填
  private String hlwyspurl;
  //    制作人代码     单一关联GetRy接口YHDM字段
  private String zzr;
  //    制作时间       制作时间，格式yyyy-MM-dd HH:mm:ss
  private String zzsj;
  //    目录序号      单一关联GetJzMl接口JMXH字段，该jmxh不要自定义
  private String jmxh;
  //*   目录类别     必须输入
  //*   默认为1
  //*   1 证据材料目录
  //*   2 法律文书目录
  private String mllb;
  //    提交形式   输入代码，代码如下：
  //15_Z00091-1 现场提交
  //15_Z00091-2 邮寄寄送
  //15_Z00091-3 电子发送
  //15_Z00091-4 庭审提交
  //15_Z00091-255 其他
  private String tjxs;

  //   提交人    材料提交人姓名或名称，汉字
  private String tjr;
  //   提交日期    提交日期，格式yyyy-MM-dd HH:mm:ss
  private String tjrq;
  //   材料关联当事人    当事人姓名或名称
  private String dsr;
  //*   材料来源      必须输入
  //输入数字，如下：
  //1：当事人材料
  //3：其他
  //4:公安
  //5:检察院
  //6:法院制作
  //7:原审材料（二审案件用）
  //8:第三方机构
  //9：音视频
  //10：上抗诉
  //11：网上立案
  //12：网上立案补充
  //13：一审同步卷
  //14：执行原案卷宗
  //15：上级法院文书
  //16：政法平台材料
  //17：诉前调解材料
  //例如当事人提交的材料，则输入1
  //注：具体传值请咨询卷宗研发或产品
  private String clly;

  //    是否需送达    0:不需要,1：需要，东软必填
  private String sfxsd;
  //    受送达人      全部当事人传输格式为all:all；
  //全部代理人传输格式为dlr:all；
  //全部辩护人传输格式为bhr:all;
  //当事人诉讼地位传输格式为ssdw:15_XXXX_X, 15_XXXX_X,...；
  //指定当事人传输格式为dsr:当事人序号，如dsr:0001, 0002...（序号可不传）；
  //代理人人传输格式为dlr:代理人序号，如dlr:4001,4002...（序号可不传）；
  //公诉人传输格式为gsr:公诉机构名称
  private String ssdr;
  //    是否需审签     0:不需要,1：需要
  private String sfxsq;
  //    是否需归档     0:不需要,1：需要
  private String sfxgd;
  //    是否需公开     0:不需要,1：需要，东软必填
  private String sfgk;
  //    公开范围      全部传输格式为all:all；
  //当事人诉讼地位传输格式为ssdw:15_XXXX_X, 15_XXXX_X,...；
  //指定当事人传输格式为dsr:当事人序号，如dsr:0001, 0002...（序号可不传）；
  //代理人人传输格式为dlr:代理人序号，如dlr:4001,4002...（序号可不传）；
  //公诉人传输格式为gsr:公诉机构名称
  private String gkfw;
  //    更新类型   U：更新，D：删除
  private String gxlx;


  //    文书http路径     txt,rtf,doc,docx,wps,xls,xlsx格式必须输入
  private String httplj;
  //    印章状态      VC1 1：已签章，0：未签章, 如果是签章后回传的文书，传空1(与慧谷对接时使用)
  private String yzzt;
  //    二阶类别
  private String ejlb;
  //    备注    备注
  private String bz;
  //    处理结果   0无冲突，1有冲突已处理
  private String cljg;
  //    处理方式   0专业法官会议讨论，1审委会讨论，多个之间用半角逗号分隔
  private String clfs;
  //    报告生成人    格式:330101zhangsan
  private String scr;
  //    签名状态    0-无效，1-待签名，2-已签名
  //GXLX为U时，判断更新签名的文书
  private String qmzt;
  //    文件子项    pdf,jpg,png,bmp,tif,tiff必须输入
  private List<MaterialsMoreDetailDto> wj;
  //    是否等同原件  非必填，1表示该文件等同于原件
  private String sfdtyj;
  //     存在纸质材料   非必填，1表示存在，0不存在
  private String czzzcl;

  //    公开状态    非必填；‘0’：待公开，‘1’：已公开，‘2’：撤销公开
  private String gkzt;
  //    节点编号    文件所在的节点编号，对应文书不同的业务节点，双方约定。
  private String jdbh;
  //    存储方式    文件存储方式，非必填
  //1：ftp存储
  //2：oss存储
  //3：亚马逊存储
  private String ccfs;
  //    存储服务名称   对应存储方式账户名称，ccfs有值时必填，
  //ftp对应ftpname，oss对应osservername，s3对应亚马逊存储账户
  private String ccnane;
  //    文件存储立卷    文件在对应存储中的存储路径，ccfs有值时必填
  private String ccpath;

  public MaterialsDto getNewMaterialsDto(RecordAndMaterialResDTO resDto) {
    MaterialsDto dto = new MaterialsDto();
    String fileName = resDto.getFileName();
    dto.setCllyid(resDto.getFileId());
    dto.setMc(fileName);
    dto.setWjgs(fileName.split("\\.")[1]);

    //后面数据中心替换
    dto.setHttplj(resDto.getFilePath());
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    dto.setZzsj(simpleDateFormat.format(resDto.getCreateTime()));
    dto.setJzlb("e");
    dto.setSfurl("1");
    dto.setMllb("1");
    if ("RECORD".equals(resDto.getSign())) {
      dto.setClly("6");
      dto.setStlb("15_000114-1");
      dto.setWslb("15_000113-8");
    }
    if ("EVIDENCE".equals(resDto.getSign()) || "REVIEW_EVIDENCE"
        .equals(resDto.getSign())) {
      dto.setClly("1");
      dto.setStlb("15_000114-255");
    }

    return dto;
  }
}