package com.beiming.odr.document.enums;

/**
 * @Description: 案件用户类型
 * @Author: caiwei
 * @Date: Created 2018-06-21
 */
public enum CaseUserTypeEnum {

  APPLICANT("申请人"), 
  RESPONDENT("被申请人"), 
  MEDIATOR("调解员"),
  APPLICANT_AGENT("申请人代理人"), 
  RESPONDENT_AGENT("被申请人代理人"),
  APP_LITIGANT_AGENT("申请人法定代表人"),
  RES_LITIGANT_AGENT("被申请人法定代表人"),
  PETITION_AGENT("信访代理人"), 
  GENERAL_AGENT("一般代理人"), 
  PRIVILEGE_AGENT("特权代理人"), 
  MEDIATOR_HELP("协助调解员"), 
  MEDIATOR_HELP_TEMPORARY("临时协助调解员"), 
  LITIGANT("当事人"),
  ARBITRATOR("仲裁员"), 
  SECRETARY("办案秘书"),
  CLERK("书记员"),
  RECORDER("记录人员"),
  APPLY_CASE("立案员"),
  JUROR("陪审员"),
  JUDGE("法官"),
  LINESMAN("边裁"),
  ASSISTANT_JUDGE("法官助理"),
  LITIGANT_WITNESS("证人"), 
  LITIGANT_THIRD("第三人"),
  // 只对会议用
  INVITATION_WATCHER("观摩人"), // 有权限;
  INVITATION_WATCHER2("仲裁员"), // 有权限;
  INVITATION_WATCHER_NO_PICTURE("观摩人无画面"),
  INVITATION_WATCHER2_NO_PICTURE("观摩人无画面"),
  APPRAISAL_INSTITUTION("鉴定机构"),
  OTHER_INTERESTED_PARTIES("其他相关方"),
  OTHER("其他参加人"),
  LITIGANT_SURVEYOR("鉴定人"),
  LITIGANT_TRANSLATOR("翻译人员"),
  LITIGANT_THIRD_AGENT("第三人代理人"),
  //四川仲裁新增角色
  RESPONDENT_COMPANY("被申请人公司"),
  APPLICANT_COMPANY("申请人公司"),
  FIRST_ARBIT("首席仲裁员");


  private String name;

  CaseUserTypeEnum(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

  /**
   * 获取代理人所代理的当事人类型
   * 
   * @param e
   * @return
   */
  public static String getClientType(String e) {
    if (APPLICANT_AGENT.name().equals(e)) {
      e = APPLICANT.name();
    }
    if (RESPONDENT_AGENT.name().equals(e)) {
      e = RESPONDENT.name();
    }
    // TODO 特权代理人类型确认?
    return e;
  }

  /**
   * 获取当事人的代理人类型
   *
   * @param e
   * @return
   */
  public static String getAgentType(String e) {
    if (APPLICANT.name().equals(e)) {
      e = APPLICANT_AGENT.name();
    }
    if (RESPONDENT.name().equals(e)) {
      e = RESPONDENT_AGENT.name();
    }
    return e;
  }

  /**
   * 判断是否为当事人类型(LITIGANT)
   * 
   * @param e
   * @return
   */
  public static Boolean isLitigant(String e) {
    return LITIGANT.name().equals(e);
  }

  /**
   * 判断是否为当事人类型(APPLICANT,RESPONDENT)
   * 
   * @param e
   * @return
   */
  public static Boolean isClient(String e) {
    return APPLICANT.name().equals(e) || RESPONDENT.name().equals(e);
  }

  /**
   * 判断角色是否需要签名
   * 
   * @param e
   * @return
   */
  public static Boolean isNeedSignType(String e) {
    return APPLICANT.name().equals(e) || RESPONDENT.name().equals(e)
        || PRIVILEGE_AGENT.name().equals(e);
  }

  /**
   * 判断角色是否不需要签名
   * 
   * @param e
   * @return
   */
  public static Boolean isNoNeedSignType(String e) {
    return GENERAL_AGENT.name().equals(e) || PETITION_AGENT.name().equals(e)
        || MEDIATOR_HELP_TEMPORARY.name().equals(e);
    // APPLICANT_AGENT.name().equals(e) || RESPONDENT_AGENT.name().equals(e)
  }

  public static Boolean isAgent(String caseUserType) {
    return caseUserType.endsWith("_AGENT");
  }

  public static Boolean isLitigantUser(String meetingUserType) {
    return LITIGANT.name().equalsIgnoreCase(meetingUserType)
        || APPLICANT.name().equalsIgnoreCase(meetingUserType)
        || RESPONDENT.name().equalsIgnoreCase(meetingUserType)
        || APPLICANT_AGENT.name().equalsIgnoreCase(meetingUserType)
        || RESPONDENT_AGENT.name().equalsIgnoreCase(meetingUserType)
        || LITIGANT_WITNESS.name().equalsIgnoreCase(meetingUserType)
        || LITIGANT_THIRD.name().equalsIgnoreCase(meetingUserType)
        || APPLICANT_COMPANY.name().equalsIgnoreCase(meetingUserType)
        || RESPONDENT_COMPANY.name().equalsIgnoreCase(meetingUserType);
  }
  
  public static Boolean isMediatorUser(String meetingUserType) {
    return MEDIATOR.name().equalsIgnoreCase(meetingUserType)
        || JUDGE.name().equalsIgnoreCase(meetingUserType)
        || ASSISTANT_JUDGE.name().equalsIgnoreCase(meetingUserType)
        || CLERK.name().equalsIgnoreCase(meetingUserType)
        || JUROR.name().equalsIgnoreCase(meetingUserType);
  }

  public static String getName(String name) {
    try {
      return CaseUserTypeEnum.valueOf(name).getName();
    } catch (Exception e) {
      return "";
    }
  }
}
