package com.beiming.odr.document.enums;

/**
 * @Description: 文书签名状态
 * @Author: caiwei
 * @Date: Created 2018-06-21
 */
public enum DocSignStatusEnum {

  SIGN_YES("已签名"), 
  SIGN_NO("已拒绝"), 
  SIGN_OFFLINE("线下签名"),
  SIGN_YES_AGENT("已签名（代）"), 
  SIGN_NO_AGENT("已拒绝（代）"),
  SIGN_OFFLINE_AGENT("线下签名（代）"),
  SIGN_AGAIN("笔录重签");

  private String name;

  DocSignStatusEnum(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

  /**
   * 判断是否为代理人处理类型
   * 
   * @param signStatus
   * @return
   */
  public static Boolean isAgentSign(String signStatus) {
    return DocSignStatusEnum.SIGN_YES_AGENT.name().equalsIgnoreCase(signStatus)
        || DocSignStatusEnum.SIGN_NO_AGENT.name().equalsIgnoreCase(signStatus);
  }
}
