package com.beiming.odr.document.enums;

import com.beiming.framework.enums.DubboResultCodeEnums;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.document.DocumentValidateMessage;

/**
 * @Description: 文书类型枚举
 * @Author: caiwei
 * @Date: Created 2018-06-21
 */
public enum DocumentTypeEnum {
  GZZC_SD_PROOF_NOTICE("受理通知书、风险和举证通知书"),
  GZZC_SD_APPLY_BOOT("应诉通知书、风险和举证通知书，申请书副本及证据材料"),
  GZZC_SD_TRIAL_NOTICE_BOOK("开庭通知书"),
  GZZC_SD_AWARD_COPY("裁决书（副本）"),
  GZZC_SD_MEDIATION_BOOK_COPY("调解书（副本）"),
  GZZC_SD_DECISION_BOOK_COPY("决定书（副本）"),
  GZZC_SD_OTHER_MATERIAL("其他材料"),
  GZZC_SD_SEND_RECEIPT("送达回证"),
  GZZC_BACKOUT_APPLY_TABLE("撤回仲裁申请表"),
  GZZC_BACKOUT_APPLY_TABLE_DRAFT("撤回仲裁申请表（草稿）"),
  GZZC_BACKOUT_DECISION_BOOK("撤诉决定书"),
  GZZC_BACKOUT_DECISION_BOOK_DRAFT("撤诉决定书（草稿）"),
  GZZC_BACKOUT_DECISION_BOOT_STAMP("撤诉决定书(盖章版)"),
  GZZC_BACKOUT_SERVICE_RECEIPT("送达回证"),
  GZZC_BACKOUT_SERVICE_RECEIPT_DRAFT("送达回证（草稿）"),
  GZZC_OTHER("其他"),
  MEDIATION_BOOK("调解协议书"), 
  COMMITMENT_BOOK("无异议调解方案承诺书"), 
  NO_DISSENT_MEDIATION_SCHEME("无异议调解方案"), 
  UNDISPUTED_FACT("无争议事实"), 
  GZZC_MEDIATION_RECORD("调解笔录"),
  MEDIATION_RECORD("调解笔录"), 
  INQUIRE_RECORD("调查笔录"), 
  TRIAL_RECORD("庭审笔录"), 
  DISSENT_RECORD("异议书"), 
  JUDICIAL_CONFIRM_APPLY_BOOK("司法确认申请书"), 
  MEDIATION_APPLY_BOOK("调解申请书"),
  ARBITRATION_BOOK("仲裁调解书"),
  GZZC_MEDIATION("调解书"),
  GZZC_MEDIATION_DRAFT("调解书（草稿）"),
  GZZC_MEDIATION_STAMP("调解书(盖章版)"),
  GZZC_MEDIATION_RECORDS("调解笔录(仲裁员版)"),
  GZZC_MEDIATION_RECORDS_DRAFT("调解笔录(草稿)"),
  GZZC_TRI_MEDIATION_RECORDS("调解笔录(三方调解版)"),
  GZZC_TRI_MEDIATION_RECORDS_DRAFT("调解笔录(三方调解版草稿)"),
  GZZC_PUBLIC_SERVICE_RECEIPT("送达回证"),
  GZZC_PUBLIC_SERVICE_RECEIPT_DRAFT("送达回证"),
  GZZC_MEDIATION_REVIEW_COMFIRM_BOOK("审查确认申请书"),
  GZZC_MEDIATION_REVIEW_COMFIRM_BOOK_DRAFT("审查确认申请书(草稿)"),
  GZZC_MEDIATION_PROTOCOL_BOOK("调解协议书"),
  GZZC_MEDIATION_PROTOCOL_BOOK_DRAFT("调解协议书(草稿)"),
  OTHER("其他"),
  GZZC_OTHERS("广州仲裁其他"),
  SEND_RECEIPT("送达回证"),
  SEND_ELECTRONIC_RECEIPT("电子送达回证"),
  SEND_SUSPECTREPORT("质证报告"),
  //2024-01-12 湖北互联网庭审项目 同步内网文书
  JUDICIAL_DOCUMENT("内网结案文书"),
  //2024-01-30 湖北互联网庭室项目 同步内网卷宗材料
  INTRANET_DOCUMENT("内网卷宗材料")
  ;

  private String name;

  DocumentTypeEnum(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

  /**
   * 判断是否为笔录类型文书
   * 
   * @param docType
   * @return
   */
  public static Boolean isRecordClerk(String docType) {
    return DocumentTypeEnum.MEDIATION_RECORD.name().equalsIgnoreCase(docType)
        || DocumentTypeEnum.INQUIRE_RECORD.name().equalsIgnoreCase(docType);
  }

  /**
   * 判断是否为私有类型文书<br>
   * 承诺书、异议书
   * 
   * @param docType
   * @return
   */
  public static Boolean isPrivateClerk(String docType) {
    return DocumentTypeEnum.COMMITMENT_BOOK.name().equalsIgnoreCase(docType)
        || DocumentTypeEnum.DISSENT_RECORD.name().equalsIgnoreCase(docType);
  }

  /**
   * 获取会议产生的笔录文书类型
   *
   * @param meetingType
   * @return
   */
  public static DocumentTypeEnum getDocTypeByMeetingType(String meetingType) {
    DocumentTypeEnum resDocType = null;
    switch (meetingType) {
      case "MEETING_SURVEY": // 调查
        resDocType = DocumentTypeEnum.INQUIRE_RECORD; // 调查笔录
        break;
      case "MEETING_MEDIATE": // 调解
        resDocType = DocumentTypeEnum.MEDIATION_RECORD; // 调解笔录
        break;
      case "SEND_SUSPECTREPORT": // 质证报告
        resDocType = DocumentTypeEnum.SEND_SUSPECTREPORT; // 质证报告
        break;
      case "SEND_ELECTRONIC_RECEIPT": // 质证报告
        resDocType = DocumentTypeEnum.SEND_ELECTRONIC_RECEIPT; // 质证报告
        break;
      default:
        resDocType = DocumentTypeEnum.MEDIATION_RECORD; // TODO 现在默认调解笔录
        break;
    }
    AssertUtils.assertNotNull(resDocType, DubboResultCodeEnums.INTERNAL_ERROR,
        DocumentValidateMessage.DOCUMENT_FOR_MEET_FIT_ERROR);
    return resDocType;
  }

  public static String contain(String name) {
    for (DocumentTypeEnum documentTypeEnum : DocumentTypeEnum.values()) {
      if (documentTypeEnum.name().equals(name)) {
        return documentTypeEnum.name;
      }
    }
    return "";
  }
}
