/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.document.enums;

public enum CaseUserTypeEnum {
    APPLICANT("\u7533\u8bf7\u4eba"),
    RESPONDENT("\u88ab\u7533\u8bf7\u4eba"),
    MEDIATOR("\u8c03\u89e3\u5458"),
    APPLICANT_AGENT("\u7533\u8bf7\u4eba\u4ee3\u7406\u4eba"),
    RESPONDENT_AGENT("\u88ab\u7533\u8bf7\u4eba\u4ee3\u7406\u4eba"),
    APP_LITIGANT_AGENT("\u7533\u8bf7\u4eba\u6cd5\u5b9a\u4ee3\u8868\u4eba"),
    RES_LITIGANT_AGENT("\u88ab\u7533\u8bf7\u4eba\u6cd5\u5b9a\u4ee3\u8868\u4eba"),
    PETITION_AGENT("\u4fe1\u8bbf\u4ee3\u7406\u4eba"),
    GENERAL_AGENT("\u4e00\u822c\u4ee3\u7406\u4eba"),
    PRIVILEGE_AGENT("\u7279\u6743\u4ee3\u7406\u4eba"),
    MEDIATOR_HELP("\u534f\u52a9\u8c03\u89e3\u5458"),
    MEDIATOR_HELP_TEMPORARY("\u4e34\u65f6\u534f\u52a9\u8c03\u89e3\u5458"),
    LITIGANT("\u5f53\u4e8b\u4eba"),
    ARBITRATOR("\u4ef2\u88c1\u5458"),
    SECRETARY("\u529e\u6848\u79d8\u4e66"),
    CLERK("\u4e66\u8bb0\u5458"),
    RECORDER("\u8bb0\u5f55\u4eba\u5458"),
    APPLY_CASE("\u7acb\u6848\u5458"),
    JUROR("\u966a\u5ba1\u5458"),
    JUDGE("\u6cd5\u5b98"),
    LINESMAN("\u8fb9\u88c1"),
    ASSISTANT_JUDGE("\u6cd5\u5b98\u52a9\u7406"),
    LITIGANT_WITNESS("\u8bc1\u4eba"),
    LITIGANT_THIRD("\u7b2c\u4e09\u4eba"),
    INVITATION_WATCHER("\u89c2\u6469\u4eba"),
    INVITATION_WATCHER2("\u4ef2\u88c1\u5458"),
    INVITATION_WATCHER_NO_PICTURE("\u89c2\u6469\u4eba\u65e0\u753b\u9762"),
    INVITATION_WATCHER2_NO_PICTURE("\u89c2\u6469\u4eba\u65e0\u753b\u9762"),
    APPRAISAL_INSTITUTION("\u9274\u5b9a\u673a\u6784"),
    OTHER_INTERESTED_PARTIES("\u5176\u4ed6\u76f8\u5173\u65b9"),
    OTHER("\u5176\u4ed6\u53c2\u52a0\u4eba"),
    LITIGANT_SURVEYOR("\u9274\u5b9a\u4eba"),
    LITIGANT_TRANSLATOR("\u7ffb\u8bd1\u4eba\u5458"),
    LITIGANT_THIRD_AGENT("\u7b2c\u4e09\u4eba\u4ee3\u7406\u4eba"),
    RESPONDENT_COMPANY("\u88ab\u7533\u8bf7\u4eba\u516c\u53f8"),
    APPLICANT_COMPANY("\u7533\u8bf7\u4eba\u516c\u53f8"),
    FIRST_ARBIT("\u9996\u5e2d\u4ef2\u88c1\u5458");

    private String name;

    private CaseUserTypeEnum(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static String getClientType(String e) {
        if (APPLICANT_AGENT.name().equals(e)) {
            e = APPLICANT.name();
        }
        if (RESPONDENT_AGENT.name().equals(e)) {
            e = RESPONDENT.name();
        }
        return e;
    }

    public static String getAgentType(String e) {
        if (APPLICANT.name().equals(e)) {
            e = APPLICANT_AGENT.name();
        }
        if (RESPONDENT.name().equals(e)) {
            e = RESPONDENT_AGENT.name();
        }
        return e;
    }

    public static Boolean isLitigant(String e) {
        return LITIGANT.name().equals(e);
    }

    public static Boolean isClient(String e) {
        return APPLICANT.name().equals(e) || RESPONDENT.name().equals(e);
    }

    public static Boolean isNeedSignType(String e) {
        return APPLICANT.name().equals(e) || RESPONDENT.name().equals(e) || PRIVILEGE_AGENT.name().equals(e);
    }

    public static Boolean isNoNeedSignType(String e) {
        return GENERAL_AGENT.name().equals(e) || PETITION_AGENT.name().equals(e) || MEDIATOR_HELP_TEMPORARY.name().equals(e);
    }

    public static Boolean isAgent(String caseUserType) {
        return caseUserType.endsWith("_AGENT");
    }

    public static Boolean isLitigantUser(String meetingUserType) {
        return LITIGANT.name().equalsIgnoreCase(meetingUserType) || APPLICANT.name().equalsIgnoreCase(meetingUserType) || RESPONDENT.name().equalsIgnoreCase(meetingUserType) || APPLICANT_AGENT.name().equalsIgnoreCase(meetingUserType) || RESPONDENT_AGENT.name().equalsIgnoreCase(meetingUserType) || LITIGANT_WITNESS.name().equalsIgnoreCase(meetingUserType) || LITIGANT_THIRD.name().equalsIgnoreCase(meetingUserType) || APPLICANT_COMPANY.name().equalsIgnoreCase(meetingUserType) || RESPONDENT_COMPANY.name().equalsIgnoreCase(meetingUserType);
    }

    public static Boolean isMediatorUser(String meetingUserType) {
        return MEDIATOR.name().equalsIgnoreCase(meetingUserType) || JUDGE.name().equalsIgnoreCase(meetingUserType) || ASSISTANT_JUDGE.name().equalsIgnoreCase(meetingUserType) || CLERK.name().equalsIgnoreCase(meetingUserType) || JUROR.name().equalsIgnoreCase(meetingUserType);
    }

    public static String getName(String name) {
        try {
            return CaseUserTypeEnum.valueOf(name).getName();
        }
        catch (Exception e) {
            return "";
        }
    }
}

