/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.document.enums;

import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.DubboResultCodeEnums;
import com.beiming.framework.util.AssertUtils;

public enum DocumentTypeEnum {
    GZZC_SD_PROOF_NOTICE("\u53d7\u7406\u901a\u77e5\u4e66\u3001\u98ce\u9669\u548c\u4e3e\u8bc1\u901a\u77e5\u4e66"),
    GZZC_SD_APPLY_BOOT("\u5e94\u8bc9\u901a\u77e5\u4e66\u3001\u98ce\u9669\u548c\u4e3e\u8bc1\u901a\u77e5\u4e66\uff0c\u7533\u8bf7\u4e66\u526f\u672c\u53ca\u8bc1\u636e\u6750\u6599"),
    GZZC_SD_TRIAL_NOTICE_BOOK("\u5f00\u5ead\u901a\u77e5\u4e66"),
    GZZC_SD_AWARD_COPY("\u88c1\u51b3\u4e66\uff08\u526f\u672c\uff09"),
    GZZC_SD_MEDIATION_BOOK_COPY("\u8c03\u89e3\u4e66\uff08\u526f\u672c\uff09"),
    GZZC_SD_DECISION_BOOK_COPY("\u51b3\u5b9a\u4e66\uff08\u526f\u672c\uff09"),
    GZZC_SD_OTHER_MATERIAL("\u5176\u4ed6\u6750\u6599"),
    GZZC_SD_SEND_RECEIPT("\u9001\u8fbe\u56de\u8bc1"),
    GZZC_BACKOUT_APPLY_TABLE("\u64a4\u56de\u4ef2\u88c1\u7533\u8bf7\u8868"),
    GZZC_BACKOUT_APPLY_TABLE_DRAFT("\u64a4\u56de\u4ef2\u88c1\u7533\u8bf7\u8868\uff08\u8349\u7a3f\uff09"),
    GZZC_BACKOUT_DECISION_BOOK("\u64a4\u8bc9\u51b3\u5b9a\u4e66"),
    GZZC_BACKOUT_DECISION_BOOK_DRAFT("\u64a4\u8bc9\u51b3\u5b9a\u4e66\uff08\u8349\u7a3f\uff09"),
    GZZC_BACKOUT_DECISION_BOOT_STAMP("\u64a4\u8bc9\u51b3\u5b9a\u4e66(\u76d6\u7ae0\u7248)"),
    GZZC_BACKOUT_SERVICE_RECEIPT("\u9001\u8fbe\u56de\u8bc1"),
    GZZC_BACKOUT_SERVICE_RECEIPT_DRAFT("\u9001\u8fbe\u56de\u8bc1\uff08\u8349\u7a3f\uff09"),
    GZZC_OTHER("\u5176\u4ed6"),
    MEDIATION_BOOK("\u8c03\u89e3\u534f\u8bae\u4e66"),
    COMMITMENT_BOOK("\u65e0\u5f02\u8bae\u8c03\u89e3\u65b9\u6848\u627f\u8bfa\u4e66"),
    NO_DISSENT_MEDIATION_SCHEME("\u65e0\u5f02\u8bae\u8c03\u89e3\u65b9\u6848"),
    UNDISPUTED_FACT("\u65e0\u4e89\u8bae\u4e8b\u5b9e"),
    GZZC_MEDIATION_RECORD("\u8c03\u89e3\u7b14\u5f55"),
    MEDIATION_RECORD("\u8c03\u89e3\u7b14\u5f55"),
    INQUIRE_RECORD("\u8c03\u67e5\u7b14\u5f55"),
    TRIAL_RECORD("\u5ead\u5ba1\u7b14\u5f55"),
    DISSENT_RECORD("\u5f02\u8bae\u4e66"),
    JUDICIAL_CONFIRM_APPLY_BOOK("\u53f8\u6cd5\u786e\u8ba4\u7533\u8bf7\u4e66"),
    MEDIATION_APPLY_BOOK("\u8c03\u89e3\u7533\u8bf7\u4e66"),
    ARBITRATION_BOOK("\u4ef2\u88c1\u8c03\u89e3\u4e66"),
    GZZC_MEDIATION("\u8c03\u89e3\u4e66"),
    GZZC_MEDIATION_DRAFT("\u8c03\u89e3\u4e66\uff08\u8349\u7a3f\uff09"),
    GZZC_MEDIATION_STAMP("\u8c03\u89e3\u4e66(\u76d6\u7ae0\u7248)"),
    GZZC_MEDIATION_RECORDS("\u8c03\u89e3\u7b14\u5f55(\u4ef2\u88c1\u5458\u7248)"),
    GZZC_MEDIATION_RECORDS_DRAFT("\u8c03\u89e3\u7b14\u5f55(\u8349\u7a3f)"),
    GZZC_TRI_MEDIATION_RECORDS("\u8c03\u89e3\u7b14\u5f55(\u4e09\u65b9\u8c03\u89e3\u7248)"),
    GZZC_TRI_MEDIATION_RECORDS_DRAFT("\u8c03\u89e3\u7b14\u5f55(\u4e09\u65b9\u8c03\u89e3\u7248\u8349\u7a3f)"),
    GZZC_PUBLIC_SERVICE_RECEIPT("\u9001\u8fbe\u56de\u8bc1"),
    GZZC_PUBLIC_SERVICE_RECEIPT_DRAFT("\u9001\u8fbe\u56de\u8bc1"),
    GZZC_MEDIATION_REVIEW_COMFIRM_BOOK("\u5ba1\u67e5\u786e\u8ba4\u7533\u8bf7\u4e66"),
    GZZC_MEDIATION_REVIEW_COMFIRM_BOOK_DRAFT("\u5ba1\u67e5\u786e\u8ba4\u7533\u8bf7\u4e66(\u8349\u7a3f)"),
    GZZC_MEDIATION_PROTOCOL_BOOK("\u8c03\u89e3\u534f\u8bae\u4e66"),
    GZZC_MEDIATION_PROTOCOL_BOOK_DRAFT("\u8c03\u89e3\u534f\u8bae\u4e66(\u8349\u7a3f)"),
    OTHER("\u5176\u4ed6"),
    GZZC_OTHERS("\u5e7f\u5dde\u4ef2\u88c1\u5176\u4ed6"),
    SEND_RECEIPT("\u9001\u8fbe\u56de\u8bc1"),
    SEND_ELECTRONIC_RECEIPT("\u7535\u5b50\u9001\u8fbe\u56de\u8bc1"),
    SEND_SUSPECTREPORT("\u8d28\u8bc1\u62a5\u544a"),
    JUDICIAL_DOCUMENT("\u5185\u7f51\u7ed3\u6848\u6587\u4e66"),
    INTRANET_DOCUMENT("\u5185\u7f51\u5377\u5b97\u6750\u6599");

    private String name;

    private DocumentTypeEnum(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static Boolean isRecordClerk(String docType) {
        return MEDIATION_RECORD.name().equalsIgnoreCase(docType) || INQUIRE_RECORD.name().equalsIgnoreCase(docType);
    }

    public static Boolean isPrivateClerk(String docType) {
        return COMMITMENT_BOOK.name().equalsIgnoreCase(docType) || DISSENT_RECORD.name().equalsIgnoreCase(docType);
    }

    public static DocumentTypeEnum getDocTypeByMeetingType(String meetingType) {
        DocumentTypeEnum resDocType = null;
        switch (meetingType) {
            case "MEETING_SURVEY": {
                resDocType = INQUIRE_RECORD;
                break;
            }
            case "MEETING_MEDIATE": {
                resDocType = MEDIATION_RECORD;
                break;
            }
            case "SEND_SUSPECTREPORT": {
                resDocType = SEND_SUSPECTREPORT;
                break;
            }
            case "SEND_ELECTRONIC_RECEIPT": {
                resDocType = SEND_ELECTRONIC_RECEIPT;
                break;
            }
            default: {
                resDocType = MEDIATION_RECORD;
            }
        }
        AssertUtils.assertNotNull((Object)((Object)resDocType), (ResultCode)DubboResultCodeEnums.INTERNAL_ERROR, (String)"\u6587\u4e66\u5339\u914d\u4f1a\u8bae\u7c7b\u578b\u9519\u8bef");
        return resDocType;
    }

    public static String contain(String name) {
        for (DocumentTypeEnum documentTypeEnum : DocumentTypeEnum.values()) {
            if (!documentTypeEnum.name().equals(name)) continue;
            return documentTypeEnum.name;
        }
        return "";
    }
}

