package com.beiming.odr.document;

import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceAutoConfigure;
import com.beiming.zipkin.starter.annotation.EnableDubboTrace;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.ImportResource;
import org.springframework.transaction.annotation.EnableTransactionManagement;


@ComponentScan({"com.beiming.odr.document", "com.beiming.framework.dynamicdatasource.service"})
@tk.mybatis.spring.annotation.MapperScan("com.beiming.odr.document.dao.mapper")
@MapperScan("com.beiming.framework.dynamicdatasource.dao")
@ImportResource(value = {
    "classpath:spring-web.xml",
    "classpath:dubbo-consumer.xml",
    "classpath:dubbo-provider.xml",
    "classpath:rocketmq/spring-rocket-producer.xml",
    "classpath:rocketmq/spring-rocket-consumer.xml"
})
@SpringBootApplication(exclude = {DataSourceAutoConfiguration.class, DruidDataSourceAutoConfigure.class})
@EnableTransactionManagement(order = 2)
@EnableDubboTrace
public class Application extends SpringBootServletInitializer {

  @Override
  protected SpringApplicationBuilder configure(SpringApplicationBuilder application) {
    return application.sources(Application.class);
  }

  public static void main(String[] args) {
    SpringApplication.run(Application.class, args);
  }
}
