package com.beiming.odr.document.aspect;

import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.context.DataSourceContextHolder;
import com.beiming.framework.domain.DubboResultBuilder;
import com.beiming.framework.enums.DubboResultCodeEnums;
import com.beiming.framework.util.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

/**
 * 捕获targetDataSource参数，动态切换数据源
 * @author zhiguang
 */
@Component
@Aspect
public class DataSourceAspect implements Ordered {

  @Around("execution(* com.beiming.odr.document.api..*.*(..))")
  public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
    String appName = AppNameContextHolder.getAppName();
    if (StringUtils.isBlank(appName)) {
      return DubboResultBuilder.error(DubboResultCodeEnums.SOURCE_NOT_FOUND, "未指定数据源");
    }
    DataSourceContextHolder.setDB(appName.toLowerCase() + "DataSource");
    return joinPoint.proceed();
  }

  @Override
  public int getOrder() {
    return -2;
  }

}