package com.beiming.odr.document.aspect;

import com.beiming.framework.constant.HttpHeaderConstants;
import com.beiming.framework.context.AppNameContextHolder;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

/**
 * 日志拦截
 */
@Component
@Aspect
@SuppressWarnings("rawtypes")
@Slf4j
public class LogAspect {

  @Pointcut("execution(* com.beiming.odr.document.api..*.*(..))")
  public void pointcut() {
  }

  @Before("pointcut()")
  public void dubboContext(JoinPoint jp) {
    String appName = AppNameContextHolder.getAppName().toLowerCase();
    log.debug("put MDC================" + appName);
    MDC.put(HttpHeaderConstants.APP_NAME, appName);
  }

}
