package com.beiming.odr.document.config;

import com.alibaba.druid.support.http.StatViewServlet;
import com.alibaba.druid.support.http.WebStatFilter;
import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.Brave.Builder;
import com.github.kristofa.brave.Sampler;
import com.github.kristofa.brave.SpanCollector;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.beanvalidation.MethodValidationPostProcessor;

/**
 * package: com.beiming.odr describe: create_user: xiet create_date: 2018/6/12 create_time: 下午5:15
 **/
@Configuration
public class Config {

  @Bean
  public MethodValidationPostProcessor validation() {
    MethodValidationPostProcessor processor = new MethodValidationPostProcessor();
    processor.setValidatedAnnotationType(Valid.class);
    return processor;
  }

  @Bean
  public ServletRegistrationBean druidServlet() {
    ServletRegistrationBean reg = new ServletRegistrationBean();
    reg.setServlet(new StatViewServlet());
    reg.addUrlMappings("/druid/*");
    //设置控制台管理用户
    reg.addInitParameter("loginUsername", "root");
    reg.addInitParameter("loginPassword", "root");
    // 禁用HTML页面上的“Reset All”功能
    reg.addInitParameter("resetEnable", "false");
    //reg.addInitParameter("allow", "127.0.0.1"); //白名单
    return reg;
  }

  @Bean
  public FilterRegistrationBean filterRegistrationBean() {
    //创建过滤器
    FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
    filterRegistrationBean.setFilter(new WebStatFilter());
    Map<String, String> initParams = new HashMap<String, String>();
    //忽略过滤的形式
    initParams.put("exclusions", "*.js,*.gif,*.jpg,*.bmp,*.png,*.css,*.ico,/druid/*");
    filterRegistrationBean.setInitParameters(initParams);
    //设置过滤器过滤路径
    filterRegistrationBean.addUrlPatterns("/*");
    return filterRegistrationBean;
  }


  //作为各调用链路，只需要负责将指定格式的数据发送给zipkin
  @Bean
  public Brave brave(SpanCollector spanCollector) {
    //指定serviceName
    Builder builder = new Builder("document");
    builder.spanCollector(spanCollector);
    //采集率
    builder.traceSampler(Sampler.create(1));
    return builder.build();
  }
}
