package com.beiming.odr.document.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.beiming.framework.context.DataSourceContextHolder;
import com.beiming.framework.dynamicdatasource.domain.DbConfig;
import com.beiming.framework.util.StringUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lombok.extern.slf4j.Slf4j;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

/**
 * 动态数据源
 *
 * @author zhiguang
 */
@Slf4j
public class DynamicDataSource extends AbstractRoutingDataSource {

  private static DynamicDataSource instance;
  private static byte[] lock = new byte[0];
  private static Map<Object, Object> dataSourceMap = new HashMap<Object, Object>();

  @Override
  protected Object determineCurrentLookupKey() {
    log.info("数据源为:==== " + DataSourceContextHolder.getDB());
    return DataSourceContextHolder.getDB();
  }

  @Override
  public void afterPropertiesSet() {
    super.afterPropertiesSet();

  }

  @Override
  public void setTargetDataSources(Map<Object, Object> targetDataSources) {
    super.setTargetDataSources(targetDataSources);
    dataSourceMap.putAll(targetDataSources);
    super.afterPropertiesSet();
  }

  public Map<Object, Object> getDataSourceMap() {
    return dataSourceMap;
  }

  public static synchronized DynamicDataSource getInstance() {
    if (instance == null) {
      synchronized (lock) {
        if (instance == null) {
          instance = new DynamicDataSource();
        }
      }
    }
    return instance;
  }

  public static boolean isExistDataSource(String key) {
    return dataSourceMap.containsKey(key);
  }

  private boolean checkConnection(Map<String, String> map, Connection connection)
      throws SQLException {
    boolean var4;
    try {
      Class.forName((String) map.get("driverClassName"));
      connection = DriverManager
          .getConnection((String) map.get("url"), (String) map.get("username"),
              (String) map.get("password"));
      log.info("测试数据库连接是否正常,result is " + !connection.isClosed());
      return false;
    } catch (Exception var8) {
      log.info("测试数据库连接是否正常,result is {} ", var8);
      var4 = true;
    } finally {
      if (connection != null && !connection.isClosed()) {
        connection.close();
      }

    }

    return var4;
  }

  public synchronized boolean addDataSource(Map<String, String> map) {
    try {
      Connection connection = null;
      if (this.checkConnection(map, (Connection) connection)) {
        return false;
      } else {
        String datasourceName = (String) map.get("datasourceName");
        String isActive = (String) map.get("isActive");
        String isDefault = (String) map.get("isDefault");
        if (StringUtils.isBlank(datasourceName)) {
          return false;
        } else if (isExistDataSource(datasourceName) && "1".equals(isActive)) {
          log.info("数据源存在，并且激活状态为1");
          return true;
        } else {
          if (!isExistDataSource(datasourceName) && "1".equals(isActive)) {
            log.info("数据源不存在，并且激活状态为1，需要初始化");
            DruidDataSource druidDataSource = (DruidDataSource) DruidDataSourceFactory
                .createDataSource(map);
            druidDataSource.init();
            dataSourceMap.put(datasourceName, druidDataSource);
            if ("1".equals(isDefault)) {
              log.info("数据源是默认数据源,需重新设置默认数据源");
              super.setDefaultTargetDataSource(druidDataSource);
            }

            this.setTargetDataSources(dataSourceMap);
            this.afterPropertiesSet();
            log.info("dataSource {} has been added", datasourceName);
          }

          if (isExistDataSource(datasourceName) && "0".equals(isActive)) {
            log.info("数据源存在，并且激活状态为0， 需要删除该数据源");
            dataSourceMap.remove(datasourceName);
            this.setTargetDataSources(dataSourceMap);
            this.afterPropertiesSet();
          }

          if (!isExistDataSource(datasourceName) && "0".equals(isActive)) {
            log.info("数据源不存在，并且激活状态为0， 不处理");
            return false;
          } else {
            return true;
          }
        }
      }
    } catch (Exception var7) {
      log.error(var7.getMessage());
      return false;
    }
  }


  public void addDataSourceBeans(List<DbConfig> dbConfigList) {
    Iterator var2 = dbConfigList.iterator();

    while (var2.hasNext()) {
      DbConfig dbConfig = (DbConfig) var2.next();
      Map<String, String> map = new HashMap();
      map.put("driverClassName", "com.kingbase8.Driver");
      map.put("filters", "stat,log4j");
      map.put("maxActive", "20");
      map.put("initialSize", "1");
      map.put("maxWait", "10000");
      map.put("minIdle", "1");
      map.put("timeBetweenEvictionRunsMillis", "2000");
      map.put("minEvictableIdleTimeMillis", "300000");
      map.put("maxOpenPreparedStatements", "600000");
      map.put("validationQuery", "select 1");
      map.put("testWhileIdle", "true");
      map.put("testOnReturn", "false");
      map.put("testOnBorrow", "false");
      map.put("poolPreparedStatements", "true");
      map.put("maxOpenPreparedStatements", "20");
      map.put("url", dbConfig.getPropUrl());
      map.put("username", dbConfig.getPropUsername());
      map.put("password", dbConfig.getPropPassword());
      map.put("isActive", dbConfig.getIsActive());
      map.put("datasourceName", dbConfig.getDatasourceName());
      map.put("isDefault", dbConfig.getIsDefault());
      this.addDataSource(map);
    }
  }
}
