package com.beiming.odr.document.config;

import com.beiming.framework.redis.RedisClusterConfig;
import com.beiming.framework.redis.RedisClusterConfigProperties;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.redis.impl.RedisServiceImpl;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration
@Import(RedisClusterConfig.class)
public class RedisConfig {

  @Bean
  RedisService redisService(RedisTemplate redisTemplate,
      RedisClusterConfigProperties redisClusterConfigProperties) {
    RedisService redisService = new RedisServiceImpl(redisTemplate, redisClusterConfigProperties);
    return redisService;
  }

}
