package com.beiming.odr.document.processor;

/**
 * @author 19417
 * @date 2024/08/08
 */

import com.beiming.framework.context.DataSourceContextHolder;
import com.beiming.framework.dynamicdatasource.domain.DataSourceChangeNotify;
import com.beiming.framework.dynamicdatasource.service.DbConfigService;
import com.beiming.odr.document.config.DynamicDataSource;
import com.beiming.pigeons.api.consumer.rocketmq.RocketMsgProcessor;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceChangeProcessor implements RocketMsgProcessor<DataSourceChangeNotify> {
  private static final Logger LOGGER = LoggerFactory.getLogger(DataSourceChangeProcessor.class);
  @Resource
  private DynamicDataSource dynamicDataSource;
  @Resource
  private DbConfigService dbConfigService;

  public DataSourceChangeProcessor() {
  }

  public String process(DataSourceChangeNotify dataSourceChangeNotify) {
    LOGGER.info("开始消费数据源变化消息。。。。。");
    DataSourceContextHolder.setDBByAppName(dataSourceChangeNotify.getAppName());
    this.dynamicDataSource.addDataSourceBeans(this.dbConfigService.loadAllDataSource());
    return null;
  }
}
