package com.beiming.odr.document.security;

import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;

@Configuration
@EnableWebSecurity
public class WebSecurityConfig extends WebSecurityConfigurerAdapter {

  @Override
  public void configure(WebSecurity web) throws Exception {
    // 配置不需要鉴权的url
    web.ignoring().antMatchers("/druid/**");
  }

  @Override
  protected void configure(HttpSecurity http) throws Exception {
    // 继承jwt配置
    super.configure(http);
    // 禁用csrf
    http.csrf().disable();
    http.cors();
    // 根据角色校验url
    // http.authorizeRequests().antMatchers("/admin/**").hasAnyAuthority("ADMIN");
    http.antMatcher("/druid/**");
  }
}