/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.document.config;

import com.alibaba.druid.filter.logging.Log4j2Filter;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceBuilder;
import com.beiming.odr.document.config.DynamicDataSource;
import com.beiming.odr.document.interceptor.InsertAndUpdateInterceptor;
import java.sql.SQLException;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class DynamicDataSourceConfiguration {
    @Resource
    private InsertAndUpdateInterceptor insertAndUpdateInterceptor;

    @Bean
    public PlatformTransactionManager txManager() {
        return new DataSourceTransactionManager(this.dynamicDataSource());
    }

    @Bean
    public Log4j2Filter log4j2Filter() {
        Log4j2Filter log4j2Filter = new Log4j2Filter();
        log4j2Filter.setStatementExecutableSqlLogEnable(true);
        return log4j2Filter;
    }

    @Bean(name={"sqlSessionFactory"})
    @ConfigurationProperties(prefix="mybatis")
    public SqlSessionFactory sqlSessionFactory() throws Exception {
        SqlSessionFactoryBean sqlSessionFactoryBean = new SqlSessionFactoryBean();
        sqlSessionFactoryBean.setDataSource(this.dynamicDataSource());
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        sqlSessionFactoryBean.setMapperLocations(resolver.getResources("classpath:/mybatis/mapper/*.xml"));
        sqlSessionFactoryBean.setPlugins(new Interceptor[]{this.insertAndUpdateInterceptor});
        return sqlSessionFactoryBean.getObject();
    }

    @Bean
    public SqlSessionTemplate sqlSessionTemplate(SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }

    private DataSource setDataSource(String appName) {
        DruidDataSource dataSource = DruidDataSourceBuilder.create().build();
        dataSource.setName(appName);
        dataSource.setDriverClassName("com.kingbase8.Driver");
        try {
            dataSource.setFilters("stat,log4j");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        dataSource.setMaxActive(20);
        dataSource.setInitialSize(1);
        dataSource.setMaxWait(10000L);
        dataSource.setMinIdle(1);
        dataSource.setTimeBetweenEvictionRunsMillis(2000L);
        dataSource.setMinEvictableIdleTimeMillis(300000L);
        dataSource.setMaxEvictableIdleTimeMillis(600000L);
        dataSource.setValidationQuery("select 1");
        dataSource.setTestWhileIdle(true);
        dataSource.setTestOnReturn(false);
        dataSource.setTestOnBorrow(false);
        dataSource.setPoolPreparedStatements(true);
        dataSource.setMaxOpenPreparedStatements(20);
        return dataSource;
    }

    @Primary
    @Bean(name={"sjsodrDataSource"}, initMethod="init")
    @ConfigurationProperties(prefix="spring.datasource.druid.dbconfig")
    public DataSource sjsodrDataSource() {
        return this.setDataSource("sjsodrDataSource");
    }

    @Bean(name={"dynamicDataSource"})
    public DataSource dynamicDataSource() {
        DynamicDataSource dynamicDataSource = new DynamicDataSource();
        dynamicDataSource.setDefaultTargetDataSource((Object)this.sjsodrDataSource());
        HashMap<String, DataSource> dsMap = new HashMap<String, DataSource>();
        dsMap.put("sjsodrDataSource", this.sjsodrDataSource());
        dynamicDataSource.setTargetDataSources(dsMap);
        return dynamicDataSource;
    }
}

