/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.document.interceptor;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.DubboResultBuilder;
import com.beiming.framework.domain.DubboResultCode;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.DubboResultCodeEnums;
import com.beiming.framework.exception.DubboBusinessException;
import com.beiming.framework.util.AssertUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DubboInterceptor
implements Ordered {
    private static final Logger log = LoggerFactory.getLogger(DubboInterceptor.class);

    @Around(value="execution(com.beiming.framework.domain.DubboResult com.beiming.odr.document.api..*(..))")
    public Object aroundSelf(ProceedingJoinPoint point) throws Throwable {
        try {
            return point.proceed();
        }
        catch (Exception e) {
            int code = DubboResultCodeEnums.INTERNAL_ERROR.value();
            String message = e.getMessage();
            if (e instanceof AssertUtils.AssertionException) {
                AssertUtils.AssertionException ae = (AssertUtils.AssertionException)e;
                code = ae.getResultCode().value();
            } else if (e instanceof DubboBusinessException) {
                DubboBusinessException ae = (DubboBusinessException)e;
                code = ae.getCode();
                message = ae.getBusinessMessage();
            }
            log.error("dubbo error : ", (Throwable)e);
            return DubboResultBuilder.error((int)code, (String)message);
        }
    }

    @Around(value="execution(com.beiming.framework.domain.DubboResult *.*(..)) && !execution(com.beiming.framework.domain.DubboResult com.beiming.odr.document.api..*(..))")
    public Object aroundOther(ProceedingJoinPoint point) throws Throwable {
        Object res = point.proceed();
        AssertUtils.assertNotNull((Object)res, (ResultCode)DubboResultCodeEnums.INTERNAL_ERROR, (String)"\u5185\u90e8\u7cfb\u7edf\u5f02\u5e38");
        if (res instanceof DubboResult) {
            DubboResult dubboRes = (DubboResult)res;
            if (dubboRes.isSuccess()) {
                return res;
            }
            if (dubboRes.getCode() == DubboResultCodeEnums.PARAM_ERROR.value()) {
                log.info("document\u670d\u52a1\u62e6\u622a\u5668\u62a5\u9519code{}, message{}", (Object)DubboResultCodeEnums.PARAM_ERROR.value(), (Object)dubboRes.getMessage());
                throw new DubboBusinessException((DubboResultCode)DubboResultCodeEnums.PARAM_ERROR, dubboRes.getMessage());
            }
            throw new DubboBusinessException((DubboResultCode)DubboResultCodeEnums.INTERNAL_ERROR, dubboRes.getMessage());
        }
        return res;
    }

    public int getOrder() {
        return -1;
    }
}

