/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.document.interceptor;

import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.DubboResultCodeEnums;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.document.common.constants.DocumentConst;
import com.beiming.odr.document.interceptor.InsertAndUpdateInterceptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.scripting.defaults.RawSqlSource;
import org.apache.ibatis.scripting.xmltags.DynamicSqlSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
@Component
public class InsertAndUpdateInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(InsertAndUpdateInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        SqlCommandType sqlCommandType = SqlCommandType.UNKNOWN;
        Object[] args = invocation.getArgs();
        MappedStatement mappedStatement = null;
        int mappedStatementIndex = 0;
        Object parameterObject = null;
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg instanceof MappedStatement) {
                mappedStatementIndex = i;
                mappedStatement = (MappedStatement)arg;
                sqlCommandType = mappedStatement.getSqlCommandType();
                continue;
            }
            parameterObject = args[i];
        }
        if (sqlCommandType == SqlCommandType.UPDATE) {
            args[mappedStatementIndex] = this.updateSql(sqlCommandType, mappedStatement, parameterObject);
            if (parameterObject != null && parameterObject instanceof Map) {
                this.setPropertyForMap(mappedStatement, sqlCommandType, parameterObject);
            } else {
                this.setProperty(mappedStatement, sqlCommandType, parameterObject);
            }
        }
        return invocation.proceed();
    }

    private MappedStatement updateSql(SqlCommandType sqlCommandType, MappedStatement mappedStatement, Object baseObject) {
        if (sqlCommandType != SqlCommandType.UPDATE) {
            return mappedStatement;
        }
        try {
            SqlSource sqlSource = mappedStatement.getSqlSource();
            if (sqlSource instanceof DynamicSqlSource && !(baseObject instanceof Map)) {
                DynamicSqlSource dynamicSqlSource = (DynamicSqlSource)sqlSource;
                BoundSql boundSql = dynamicSqlSource.getBoundSql(baseObject);
                String updateSql = boundSql.getSql();
                Integer version = this.getVersionValue(baseObject);
                if (updateSql.contains(" WHERE  Id =") && version != null) {
                    updateSql = updateSql.replace(" WHERE  Id =", " WHERE version = " + version + " and Id =");
                    MappedStatement newMappedStatement = this.copyFromMappedStatement(mappedStatement, boundSql, updateSql);
                    return newMappedStatement;
                }
            }
        }
        catch (Exception e) {
            log.error("InsertAndUpdateInterceptor updateSql error {}", (Throwable)e);
        }
        return mappedStatement;
    }

    private MappedStatement copyFromMappedStatement(MappedStatement ms, BoundSql boundSql, String sql) {
        BoundSql newBoundSql = new BoundSql(ms.getConfiguration(), sql, boundSql.getParameterMappings(), boundSql.getParameterObject());
        1 newSqlSource = new /* Unavailable Anonymous Inner Class!! */;
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), ms.getId(), (SqlSource)newSqlSource, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        if (ms.getKeyProperties() != null && ms.getKeyProperties().length > 0) {
            builder.keyProperty(ms.getKeyProperties()[0]);
        }
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        builder.resultMaps(ms.getResultMaps());
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties obj) {
    }

    private void setPropertyForMap(MappedStatement mappedStatement, SqlCommandType sqlCommandType, Object arg) {
        if (arg == null) {
            return;
        }
        Map map = (Map)arg;
        Integer version = null;
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            if ("record".equals(key)) {
                try {
                    version = this.getVersionValue(value);
                }
                catch (Exception e) {
                    log.error("InsertAndUpdateInterceptor setPropertyForMap error {}", (Throwable)e);
                }
            } else {
                if ("example".equals(key) && value instanceof Example) {
                    Example example = (Example)value;
                    List criterias = example.getOredCriteria();
                    AssertUtils.assertFalse((boolean)CollectionUtils.isEmpty((Collection)criterias), (ResultCode)DubboResultCodeEnums.INTERNAL_ERROR, (String)"\u66f4\u65b0\u6570\u636e\u5e93\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
                    for (Example.Criteria criteria : criterias) {
                        AssertUtils.assertFalse((boolean)CollectionUtils.isEmpty((Collection)criteria.getCriteria()), (ResultCode)DubboResultCodeEnums.INTERNAL_ERROR, (String)"\u66f4\u65b0\u6570\u636e\u5e93\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (version == null) continue;
                    example.and(example.createCriteria().andEqualTo("version", (Object)version));
                    continue;
                }
                if (String.valueOf(key).contains("param")) continue;
            }
            if (value instanceof List) {
                List list = (List)value;
                for (Object model : list) {
                    this.setProperty(mappedStatement, sqlCommandType, model);
                }
                continue;
            }
            this.setProperty(mappedStatement, sqlCommandType, value);
        }
    }

    private void setProperty(MappedStatement mappedStatement, SqlCommandType sqlCommandType, Object model) {
        if (model == null) {
            return;
        }
        SqlSource sqlSource = mappedStatement.getSqlSource();
        if (sqlSource instanceof RawSqlSource || model instanceof String) {
            return;
        }
        Field[] fields = model.getClass().getSuperclass().getDeclaredFields();
        if (fields == null || fields.length == 0) {
            fields = model.getClass().getDeclaredFields();
        }
        try {
            for (int i = 0; i < fields.length; ++i) {
                String fieldName = fields[i].getName();
                fieldName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                Method m = null;
                System.out.println("------------insertAndUpdateInterceptor-------" + fieldName);
                if (sqlCommandType == SqlCommandType.INSERT) {
                    if ("createTime".equalsIgnoreCase(fieldName)) {
                        m = model.getClass().getMethod("set" + fieldName, Date.class);
                        m.invoke(model, new Date());
                    }
                    if ("status".equalsIgnoreCase(fieldName)) {
                        m = model.getClass().getMethod("get" + fieldName, new Class[0]);
                        Integer status = (Integer)m.invoke(model, new Object[0]);
                        m = model.getClass().getMethod("set" + fieldName, fields[i].getType() == Integer.class ? Integer.class : String.class);
                        Object[] objectArray = new Object[1];
                        objectArray[0] = null == status ? (fields[i].getType() == Integer.class ? Integer.valueOf(0) : "0") : status;
                        m.invoke(model, objectArray);
                    }
                    if (!"version".equalsIgnoreCase(fieldName)) continue;
                    m = model.getClass().getMethod("set" + fieldName, Integer.class);
                    m.invoke(model, DocumentConst.DEFAULT_VERSION);
                    continue;
                }
                if (sqlCommandType != SqlCommandType.UPDATE) continue;
                if ("updateTime".equalsIgnoreCase(fieldName)) {
                    m = model.getClass().getMethod("set" + fieldName, Date.class);
                    m.invoke(model, new Date());
                }
                if (!"version".equalsIgnoreCase(fieldName)) continue;
                m = model.getClass().getMethod("get" + fieldName, new Class[0]);
                Integer version = (Integer)m.invoke(model, new Object[0]);
                m = model.getClass().getMethod("set" + fieldName, Integer.class);
                m.invoke(model, version == null ? DocumentConst.DEFAULT_VERSION : version + 1);
            }
        }
        catch (Exception e) {
            log.error("InsertAndUpdateInterceptor setProperty error {}", (Throwable)e);
        }
    }

    private Integer getVersionValue(Object baseObject) {
        Integer version = null;
        if (!(baseObject instanceof Map)) {
            try {
                Field field = baseObject.getClass().getSuperclass().getDeclaredField("version");
                if (field == null) {
                    field = baseObject.getClass().getDeclaredField("version");
                }
                if (field == null) {
                    return version;
                }
                String fieldName = field.getName();
                fieldName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                Method m = baseObject.getClass().getMethod("get" + fieldName, new Class[0]);
                version = (Integer)m.invoke(baseObject, new Object[0]);
            }
            catch (Exception e) {
                log.error("InsertAndUpdateInterceptor getVersionValue error {}", (Throwable)e);
            }
        }
        return version;
    }
}

