package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.dto.requestdto.BackstageUserAddReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageUserListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageUserRoleAddReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageUserSearchReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageUserUpdateStatusReqDTO;
import com.beiming.odr.user.api.dto.requestdto.UserImportErrorLogReqDTO;
import com.beiming.odr.user.api.dto.responsedto.BackstageUserInfoResDTO;
import java.util.List;

/**
 * 工作人员相关接口
 * 
 * @author fanheshui
 */
public interface BackstageUserServiceApi {
  /**
   * 添加工作人员
   */

  DubboResult insertBackstageUser(BackstageUserAddReqDTO backstageUserAddReqDTO);

  /**
   * 修改工作人员
   */
  DubboResult updateBackstageUser(BackstageUserAddReqDTO backstageuserAddReqDTO);

  /**
   * 查询工作人员
   */
  DubboResult<BackstageUserInfoResDTO> searchBackstageUser(BackstageUserSearchReqDTO backstageUserSearchReqDTO);

  /**
   * 更新工作人员状态-禁用或启用
   */
  DubboResult updateBackstageUserStatus(BackstageUserUpdateStatusReqDTO req);

  /**
   * 工作人员列表
   */
  DubboResult<PageInfo<BackstageUserInfoResDTO>> listBackstageUser(BackstageUserListReqDTO backstageUserListReqDTO);

  /**
   * 插入导入失败的记录
   */
  DubboResult<Integer> insertErrorLog(List<UserImportErrorLogReqDTO> errorList);

  /**
   * 查询驻所的工作人员
   */
  DubboResult<BackstageUserInfoResDTO> searchBackstageUserByPolice(String policeStationUserId);

  /**
   * 手机号查询的工作人员
   */
  DubboResult<BackstageUserInfoResDTO> searchBackstageUserByMobile(String mobilePhone);

  /**
   * 添加工作人员角色
   */
  DubboResult addBackstageUserRole(BackstageUserRoleAddReqDTO reqDTO);

  /**
   * 添加工作人员角色
   */
  DubboResult updatePoliceStationUserId(Long userId, String policeStationUserId);
}
