package com.beiming.odr.user.api;

import com.alibaba.fastjson.JSONObject;
import com.beiming.odr.user.api.dto.responsedto.OrgPersonNumRespDTO;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Param;

/**
 * @author 46915
 * @date 2023/02/20
 * @describes
 */
public interface CaseReportServiceApi {

  // 查询地区下的机构总数与调解员总数
  List<Map<String, Object>> getOrgAndMediatorByArea();

  // 获取用户注册量
  Integer getTotalUsers();

  // 获取调解机构数
  Integer getTotalOrg();

  // 获取调解员总数
  Integer getTotalMediator();

  List<Map<String, Integer>> getOrganizationByArea(String areaCode);

  List<Map<String, Object>> getUserEvaluateGradeInfo(List<Integer> caseIds);

  JSONObject userLoginRate(String startDate, String endDate);

  JSONObject getUserAgeAndEducationInfo(String areaCode);

  List<Map<String, Integer>> getOrganizationNumByArea(String areaCode);

  List<OrgPersonNumRespDTO> getOrgPersonNumByAreaAndTime(@Param("areaCode") String areaCode,
      @Param("startTime") String startTime, @Param("endTime") String endTime);

  List<OrgPersonNumRespDTO> getOrgNumByAreaAndTime(@Param("areaCode") String areaCode,
      @Param("startTime") String startTime, @Param("endTime") String endTime);
}
