package com.beiming.odr.user.api;

import com.github.pagehelper.PageInfo;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.user.api.dto.requestdto.NoticeAndNewsExamineDTO;
import com.beiming.odr.user.api.dto.requestdto.NoticeAndNewsManageDTO;
import java.util.List;

/**
 * @author 46915
 * @date 2022/11/27
 * @describes
 */
public interface NoticeAndNewsManageServiceApi {

  /**
   * 添加公告/新闻资讯
   */
  DubboResult addNotice(NoticeAndNewsManageDTO noticeAndNewsManageDTO);

  /**
   * 更新公告/新闻资讯浏览次数
   */
  DubboResult updateViewNumber(Long id);

  /**
   * 获取公告/新闻资讯详情
   */
  DubboResult getContent(Long id);

  /**
   * 更新公告/新闻资讯
   */
  DubboResult updateNotice(NoticeAndNewsManageDTO noticeAndNewsManageDTO);

  /**
   * 下架公告/新闻资讯
   */
  DubboResult withdrawNotice(Long id, String informationType, Integer isShow);

  /**
   * 发布公告/新闻资讯审核
   */
  DubboResult publishNotice(NoticeAndNewsExamineDTO noticeAndNewsExamineDTO);

  /**
   * 审核公告/新闻资讯
   */
  DubboResult examine(NoticeAndNewsExamineDTO noticeAndNewsExamineDTO);

  /**
   * 分页获取公告/新闻资讯
   */
  DubboResult<PageInfo<NoticeAndNewsManageDTO>> getNoticeManageData(String informationType, String title, Integer publishStatus, Integer isShow, Integer pageSize, Integer pageNum);

  /**
   * 分页获取公告/新闻资讯审核列表
   */
  DubboResult<PageInfo<NoticeAndNewsExamineDTO>> getNoticeExamineData(String informationType, Integer examineStatus,
      String organization, String startTime,
      String endTime, Integer pageSize, Integer pageNum);

  /**
   * 根据角色id获取角色所属机构
   */
  DubboResult getOrganizationByUserId(Long userId);


  DubboResult getTopNotice(List<Long> existIds, Integer pageSize, Integer pageNum);

  DubboResult updateNoticeAndNewsExamine(NoticeAndNewsExamineDTO noticeAndNewsExamineDTO);
}