package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.user.api.dto.UserRoleInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.AddServicePersonReqDTO;
import com.beiming.odr.user.api.dto.requestdto.SearchServicePersonReqByMobileDTO;
import com.beiming.odr.user.api.dto.requestdto.SearchServicePersonReqDTO;
import com.beiming.odr.user.api.dto.requestdto.ServicePersonUpdateRoleReqDTO;
import com.beiming.odr.user.api.dto.responsedto.SearchServicePersonResDTO;
import com.beiming.odr.user.api.dto.responsedto.SerchServicePersonGrantAuthInfoResDTO;
import java.util.ArrayList;
import javax.validation.Valid;

/**
 * 服务人员相关接口
 * 
 * @author
 */
@Valid
public interface ServicePersonServiceApi {



  /**
   * 机构管理员-添加服务人员
   */
  public DubboResult<Long> addServicePerson(AddServicePersonReqDTO addServicePersonReqDTO);

  /**
   * 查询服务人员详细信息
   */
  public DubboResult<SearchServicePersonResDTO> searchServicePerson(
      SearchServicePersonReqDTO searchServicePersonReqDTO);

  /**
   * 机构管理员-编辑服务人员
   */
  DubboResult updateServicePerson(AddServicePersonReqDTO addServicePersonReqDTO);


  /**
   * 查询服务人员授权信息
   */
  DubboResult<SerchServicePersonGrantAuthInfoResDTO> serchServicePersonGrantAuthInfo(Long userId);

  /**
   * 查询服务人员详细信息-通过手机号码
   */
  DubboResult<SearchServicePersonResDTO> searchServicePersonByMobile(SearchServicePersonReqByMobileDTO request);


  /**
   * 机构管理员-更新服务人员权限
   */
  DubboResult updateServicePersonRole(
      @Valid ServicePersonUpdateRoleReqDTO servicePersonUpdateRoleReqDTO);

  /**
   * 通过用户的id,和角色，查询当前用户是哪些机构的机构管理员信息
   */
  DubboResult<ArrayList<UserRoleInfoDTO>> queryRoleWithOrg(Long userId, String role);

}
