package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.common.enums.PersonTypeEnum;
import com.beiming.odr.user.api.common.enums.UserLoginTypeEnum;
import com.beiming.odr.user.api.dto.PlatformContactInfoDTO;
import com.beiming.odr.user.api.dto.UserInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.CaseUserRegisterReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CommonIdReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CommonUserRegisterReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CommonUserResetPasswordReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CommonUserUpdatePasswordReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CommonUserUpdateReqDTO;
import com.beiming.odr.user.api.dto.requestdto.FaceRealNameAuthenticationReqDTO;
import com.beiming.odr.user.api.dto.requestdto.RealNameAuthenticationReqDTO;
import com.beiming.odr.user.api.dto.requestdto.SelMediatorSingleInfoReqDTO;
import com.beiming.odr.user.api.dto.requestdto.ServicePersonListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.ShortUrlCreateReqDTO;
import com.beiming.odr.user.api.dto.requestdto.ShortUrlSearchReqDTO;
import com.beiming.odr.user.api.dto.requestdto.SpecialUserOrgRlatListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.UserQrCodeLoginReqDTO;
import com.beiming.odr.user.api.dto.requestdto.UserSignReqDTO;
import com.beiming.odr.user.api.dto.responsedto.CaseCountDownMediatorResDTO;
import com.beiming.odr.user.api.dto.responsedto.CaseUserRegisterResDTO;
import com.beiming.odr.user.api.dto.responsedto.CommonUserSearchResDTO;
import com.beiming.odr.user.api.dto.responsedto.LoginInfoResDTO;
import com.beiming.odr.user.api.dto.responsedto.MediatorSingleInfoResDTO;
import com.beiming.odr.user.api.dto.responsedto.OrganizationResDTO;
import com.beiming.odr.user.api.dto.responsedto.ServicePersonListResDTO;
import com.beiming.odr.user.api.dto.responsedto.ShortUrlResDTO;
import com.beiming.odr.user.api.dto.responsedto.UserRoleInfoListResDTO;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;

@Valid
public interface UserServiceApi {

  /**
   * 新增普通用户
   */
  DubboResult<LoginInfoResDTO> insertCommonUser(@Valid CommonUserRegisterReqDTO commonUserRegisterReqDTO);

  /**
   * 用户登录 -可以通过mobile也可以通过loginName
   */
  DubboResult<LoginInfoResDTO> userLogin(String mobile, String password, String loginName, UserLoginTypeEnum loginType);

  /**
   * 更新普通用户
   */
  DubboResult updateCommonUser(CommonUserUpdateReqDTO commonUserUpdateReqDTO);

  /**
   * 重置登录密码
   */
  DubboResult resetUserPassword(@Valid CommonUserResetPasswordReqDTO commonUserResetPasswordReqDTO);

  /**
   * 人脸识别通过-设置
   *
   * @param userBasicsId 用户ID
   */
  DubboResult setFacialVerify(Long userBasicsId);


  /**
   * 实名认证-设置
   */
  DubboResult setRealNameAuthentication(Long userId, RealNameAuthenticationReqDTO realNameAuthenticationReqDTO);

  /**
   * 查询普通用户的信息
   */
  DubboResult<CommonUserSearchResDTO> searchCommonUser(CommonIdReqDTO commonIdReqDTO);

  /**
   * 查询服务人员列表分页
   */
  DubboResult<PageInfo<ServicePersonListResDTO>> getServicePersonListPage(ServicePersonListReqDTO servicePersonListReqDTO);


  DubboResult<ServicePersonListResDTO> getMediationDeatil(String userId);

  /**
   * 案件用户注册接口
   */
  DubboResult<CaseUserRegisterResDTO> caseUserregister(@Valid CaseUserRegisterReqDTO caseUserRegisterReqDTO);

  /**
   * 上传用户签名
   */
  DubboResult uploadUserSign(UserSignReqDTO userSignReqDTO);

  /**
   * 查询签名url
   */
  DubboResult querySignUrl(Long userId);

  /**
   * 修改密码
   */
  DubboResult updatePassword(CommonUserUpdatePasswordReqDTO commonUserUpdatePasswordReqDTO);

  /**
   * 修改手机号码
   */
  DubboResult updateMobilePhone(Long userId, String mobilePhone);

  /**
   * 修改邮箱
   */
  DubboResult updateEmail(Long userId, String email);

  /**
   * 修改个人用户签名
   */
  DubboResult updateUserSign(UserSignReqDTO userSignReqDTO);

  /**
   * 用过手机号码判断用户是否存在
   *
   * @param mobile         手机号码
   * @param personTypeEnum 人员类型
   * @return true 存在 false 不存在
   */
  DubboResult<Boolean> checkUserByMobile(String mobile, PersonTypeEnum personTypeEnum);

  DubboResult<LoginInfoResDTO> getUserByMobile(String mobile, PersonTypeEnum personTypeEnum);

  /**
   * 获取用户角色信息
   *
   * @param userId 用户id
   */
  DubboResult<UserRoleInfoListResDTO> getRoleInfoByUserId(Long userId);

  /**
   * 获取内部测试用户userId
   */
  DubboResult<String> getInternalTestUserId();

  /**
   * 保存内部测试用户userId,id以逗号隔开
   */
  DubboResult saveInternalTestUserId(String userId);

  /**
   * 获取内部测试机构id
   */
  DubboResult<String> getInternalTestOrgId();

  /**
   * 保存内部测试机构id,id以逗号隔开
   */
  DubboResult saveInternalTestOrgId(String orgId);

  /**
   * 校验姓名和身份证是否匹配
   */
  DubboResult<Boolean> checkRealNameAuthentication(RealNameAuthenticationReqDTO req);

  /**
   * 根据区域代码查询下面的所有调解员 只需要传区域代码
   */
  DubboResult<ArrayList<MediatorSingleInfoResDTO>> selMediatorSingleInfoListByAreaCode(
      @Valid SelMediatorSingleInfoReqDTO arg0);

  DubboResult<CommonUserSearchResDTO> searchUserByMobile(String mobile,
      PersonTypeEnum personTypeEnum);

  /**
   * <pre>
   * 根据机构号查询该机构下的所有调解员
   * 只需要传机构代码
   * @param arg0
   * @return
   */
  DubboResult<ArrayList<MediatorSingleInfoResDTO>> selMediatorSingleInfoListWithOrgManage(
      @Valid SelMediatorSingleInfoReqDTO arg0);

  /**
   * <pre>
   * 腾讯实名认证
   * @param DubboResult
   * @return
   */
  DubboResult faceRealNameAuthentication(FaceRealNameAuthenticationReqDTO req);

  DubboResult<LoginInfoResDTO> qrCodeLogin(UserQrCodeLoginReqDTO requestDTO);

  /**
   * 根据案件信息ID和编号生成短网址
   */
  DubboResult<ShortUrlResDTO> createShortUrl(ShortUrlCreateReqDTO shortUrlCreateReqDTO);

  /**
   * 根据短网址查询案件信息ID和编号 400, "参数错误"  资源未找到
   */
  DubboResult<ShortUrlResDTO> searchMainInfo(ShortUrlSearchReqDTO shortUrlSearchReqDTO);

  DubboResult<UserInfoDTO> selectById(Long id);

  DubboResult<PageInfo<OrganizationResDTO>> relationOrg(SpecialUserOrgRlatListReqDTO query);

  DubboResult<Integer> checkWeak(Long userId);

  /**
   * 根据联系人姓名，返回联系人列表
   */
  DubboResult<PageInfo<PlatformContactInfoDTO>> listPlatformMediator(String contactName,
      Long userId, int pageIndex, int pageSize);

  List<PlatformContactInfoDTO> listPlatformMediatorByIds(List<Long> userIdSet);

  List<CaseCountDownMediatorResDTO> listCaseCountDownMediator(List<Long> mediatorIds);
}
