package com.beiming.odr.user.api.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 调解类型枚举
 * @author zhiguang
 */
public enum MediationTypeEnum {
  PEOPLE_MEDIATION("人民调解", "JGLX_001"),
  ADMINISTRATION_MEDIATION("行政调解", "JGLX_002"),
  ARBITRATE_MEDIATION("仲裁调解", ""),
  JUDICIAL_MEDIATION("司法调解", ""),
  BUSINESS_MEDIATION("商业调解", "JGLX_004"),
  LAWYER_MEDIATION("律师调解", ""),
  NOTARIAL_MEDIATION("公证调解", ""),
  MAJOR_MEDIATION("专业调解", ""),
  INDUSTRY_MEDIATION("行业调解", "JGLX_003"),
  OTHER_MEDIATION("其他调解", "JGLX_005");

  private String name;
  private String infoCollectCode;

  MediationTypeEnum(String name, String infoCollectCode) {
    this.name = name;
    this.infoCollectCode = infoCollectCode;
  }

  public String getName() {
    return name;
  }

  public String getInfoCollectCode() {
    return infoCollectCode;
  }

  public static Map<String, MediationTypeEnum> getMediationTypeMap() {
    Map<String, MediationTypeEnum> mediationTypeMap = new HashMap<>();
    for (MediationTypeEnum itemEnum : MediationTypeEnum.values()) {
      mediationTypeMap.put(itemEnum.getName(), itemEnum);
    }
    return mediationTypeMap;
  }
}
