package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import lombok.Data;

/**
 * 后台机构更新请求参数
 */
@Data
public class BackstageOrganizationUpdateReqDTO implements Serializable {



  /**
   * 机构id
   */
  @NotBlank(message = "{user.orgIdNotBlank}")
  private Long orgId;

  /**
   * 机构代码
   */
  private String code;

  /**
   * 机构名称
   */
  private String name;

  /**
   * 父级id
   */
  private Long parentId;

  /**
   * 父级name
   */
  private String parentName;

  /**
   * 机构类型代码
   */
  private String typeCode;

  /**
   * 机构类型名称
   */
  private String typeName;

  /**
   * 调解类型代码
   */
  private String mediateCode;

  /**
   * 调解类型名称
   */
  private String mediateName;

  /**
   * 组织机构证书图片
   */
  private String imgUrl;

  /**
   * 省
   */
  private String provinceCode;

  /**
   * 省名称
   */
  private String provinceName;

  /**
   * 市代码
   */
  private String cityCode;

  /**
   * 市名称
   */
  private String cityName;

  /**
   * 区代码
   */
  private String areaCode;

  /**
   * 区名称
   */
  private String areaName;

  /**
   * 街道代码
   */
  private String streetCode;

  /**
   * 街道名称
   */
  private String streetName;

  /**
   * 社区代码
   */
  private String communityCode;

  /**
   * 社区名称
   */
  private String communityName;

  /**
   * 座机电话
   */
  private String seatPhone;

  /**
   * 机构logo图片
   */
  private String logoImgUrl;

  /**
   * 联系人
   */
  private String contactName;

  /**
   * 联系人职位
   */
  private String contactPosition;

  /**
   * 联系人电话
   */
  private String contactPhone;

  /**
   * 联系人邮件
   */
  private String contactEmail;

  /**
   * 联系人照片
   */
  private String contactImgUr;

  /**
   * 行政级别
   */
  private Integer grade;

  /**
   * 行政级别等级
   */
  private Integer gradeLevel;

  /**
   * 机构简介
   */

  private String introduction;

  /**
   * 机构详细地址
   */
  private String detailedAddress;

  /**
   * 纠纷类型代码
   */
  private String disputeTypeCode;

  /**
   * 纠纷类型名称
   */
  private String disputeTypeName;

  /**
   * 是否具有司法确认
   */
  private Integer isJudicialConfirmation;

  /**
   * 是否测试机构
   */
  private Boolean isTestOrg;

  /**
   * 是否对群众开放
   */
  private Boolean isPublicOrg;

  private String orgRoleType;

  /**
   * 公章url
   */
  private String officialSealUrl;
  /**
   * 机构签章图片url
   */
  private String introductionSealImgUrl;

  /**
   * 是否显示机构简介 1：是 0：否
   */
  private Integer isShowIntroduction;
}
