package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.common.enums.PersonTypeEnum;
import lombok.Data;

/**
 * 重置密码
 */
@Data
public class CommonUserResetPasswordReqDTO implements Serializable {

  /**
   * 手机号
   */
  @Pattern(regexp = UserConst.REGEX_MOBILE_EXACT, message = "{user.phoneFormatError}")
  @NotBlank(message = "{user.phoneNotBlank}")
  private String mobilePhone;

  /**
   * 密码
   */
  @Pattern(regexp = UserConst.REGEX_PASSWORD, message = "{user.passwordFormatError}")
  @NotBlank(message = "{user.passwordNotBlank}")
  private String password;

  @NotNull(message = "{user.memberTypeNotBlank}")
  private PersonTypeEnum personTypeEnum;
}
