package com.beiming.odr.user.api.dto.requestdto;

import com.beiming.odr.user.api.common.enums.MediationTypeEnum;
import com.beiming.odr.user.api.common.enums.OrgRoleTypeEnum;
import com.beiming.odr.user.api.common.enums.OrganizationTypeEnum;
import java.util.Date;
import lombok.Data;

@Data
public class IntranetOrganizationReqDTO {

  /**
   * 关联平台的机构id
   */
  private String thirdId;

  /**
   * 机构代码
   */
  private String code;

  /**
   * 机构名称
   */
  private String name;

  /**
   * 关联平台的父机构id
   */
  private String thirdParentId;

  /**
   * 联系人
   */
  private String contactName;

  /**
   * 联系人电话
   */
  private String contactPhone;

  /**
   * 机构详细地址
   */
  private String detailedAddress;

  /**
   * 办公电话
   */
  private String seatPhone;

  /**
   * 机构简介
   */
  private String introduction;

  /**
   * 创建时间
   */
  private Date createDate;

  /**
   * 状态 0 正常 1 删除
   */
  private String status;

  public BackstageOrganizationAddReqDTO convertBackstageOrgAddReqDTO() {
    BackstageOrganizationAddReqDTO reqDTO = new BackstageOrganizationAddReqDTO();
    reqDTO.setName(this.name);
    reqDTO.setProvinceCode("4400000000");
    reqDTO.setProvinceName("广东省");
    reqDTO.setCityCode("441900000000");
    reqDTO.setCityName("东莞市");
//        reqDTO.setAreaCode();
//        reqDTO.setAreaName();
//        reqDTO.setStreetCode();
//        reqDTO.setStreetName();
//        reqDTO.setCommunityCode();
//        reqDTO.setCommunityName();
    reqDTO.setContactName(this.contactName);
    reqDTO.setContactPosition(this.detailedAddress);
    reqDTO.setContactPhone(this.contactPhone);
    reqDTO.setGrade(null);
    reqDTO.setGradeLevel(5);
    reqDTO.setIntroduction(this.introduction);
    reqDTO.setDetailedAddress(this.detailedAddress);
    reqDTO.setDisputeTypeCode(
        "MARITAL_INHERITANCE,TRAFFIC_ACCIDENT,MEDICAL_TANGLE,ADJACENCY_RELATION,HOUSE_DISPUTE,LOAN_DISPUTE,TOURIST_DISPUTES,CONTRACT_DISPUTE,VENTURE_DISPUTE,INTELLECTUAL_PROPERTY_RIGHT,ELECTRONIC_BUSINESS,COMPENSAT_DISPUTE,LAND_DISPUTE,FOREIGN_COMMERCIAL_AFFAIRS,OTHER_DISPUTES,LAND_MOVE,ENV_DISPUTE,PROPERTY_DISPUTE,LABOUR_DISPUTE");
    reqDTO.setDisputeTypeName(
        "婚姻家庭纠纷,道路交通事故纠纷,医疗纠纷,邻里纠纷,房屋宅基地纠纷,消费纠纷,旅游纠纷,合同纠纷,生产经营纠纷,知识产权纠纷,互联网纠纷,损害赔偿纠纷,山林土地纠纷,商事纠纷,其他纠纷,征地拆迁纠纷,环境污染纠纷,物业管理纠纷,劳动争议纠纷");
    reqDTO.setIsJudicialConfirmation(1);
    reqDTO.setIsTestOrg(false);
    reqDTO.setOrgRoleType(OrgRoleTypeEnum.THIRD_ROLE_NORMAL.name());
    reqDTO.setTypeCode(OrganizationTypeEnum.OTHER_DISPUTE.name());
    reqDTO.setTypeName(OrganizationTypeEnum.OTHER_DISPUTE.getName());
    reqDTO.setMediateCode(MediationTypeEnum.PEOPLE_MEDIATION.name());
    reqDTO.setMediateName(MediationTypeEnum.PEOPLE_MEDIATION.getName());
    reqDTO.setStatus(status);
    return reqDTO;
  }
}