package com.beiming.odr.user.api.dto.requestdto;


import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * @author 46915
 * @date 2022/11/27
 * @describes
 */
@Data
public class NoticeAndNewsManageDTO implements Serializable {

  private Long id;

  /**
   * 标题
   */
  private String title;

  /**
   * 是否发布(1是0否)
   */
  private Integer isPublish;

  /**
   * 发布状态
   * 新闻资讯：（1草稿，2审核中，3审核通过，4审核不通过）
   */
  private Integer publishStatus;

  /**
   * 浏览数量
   */
  private Integer viewNumber;

  /**
   * 发布时间
   */
  private String publishTime;

  /**
   * 是否展示（1是0否）
   */
  private Integer isShow;

  /**
   * 信息类别（公告，新闻资讯）
   */
  private String informationType;

  /**
   * 信息发布人
   */
  private String publishPerson;

  /**
   * 内容详情
   */
  private String content;

  /**
   * 封面图地址
   */
  private String coverImgUrl;

  /**
   * 创建人
   */
  private String createUser;

  /**
   * 创建时间
   */
  private Date createTime;

  /**
   * 修改人
   */
  private String updateUser;

  /**
   * 修改时间
   */
  private Date updateTime;

  /**
   * 版本号
   */
  private Integer version;

  /**
   * 状态 0 正常 1 删除
   */
  private String status;

  /**
   * 备注
   */
  private String remark;

  /**
   * 备注
   */
  private String refuseReason;
}