package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.common.enums.UserSexTypeEnum;
import lombok.Data;

/**
 * 新增普通用户
 */
@Data
public class OrdinaryUserAddReqDTO implements Serializable {

  /**
   * 姓名
   */
  @NotBlank(message = "{user.userNameNotBlank}")
  private String userName;


  /**
   * 手机号
   */
  @Pattern(regexp = UserConst.REGEX_MOBILE_EXACT, message = "{user.phoneFormatError}")
  @NotBlank(message = "{user.phoneNotBlank}")
  private String mobilePhone;

  /**
   * 身份证
   */
  @NotBlank(message = "{user.idCardNotBlank}")
  @Pattern(regexp = UserConst.REGEX_ID_CARD, message = "{user.idCardNotIncorrect}")
  private String idCard;

  /**
   * 性别
   */
  @NotNull(message = "{user.sexNotBlank}")
  private UserSexTypeEnum sex;

  /**
   * 工作机构
   */
  private String workOrganization;
}
