package com.beiming.odr.user.api.dto.requestdto;

import com.beiming.framework.page.PageQuery;
import java.io.Serializable;
import java.util.List;
import lombok.Data;

/**
 * 查询机构dto
 *
 * @author zhiguang
 */
@Data
public class OrganizationListReqDTO extends PageQuery implements Serializable {

  /**
   * 机构类型代码
   */
  private String orgTypeCode;

  /**
   * 服务区域代码
   */
  private String serviceAreaCode;

  /**
   * 机构名称
   */
  private String orgName;

  /**
   * 调解类型代码
   */
  private String mediateCode;

  /**
   * 纠纷类型代码
   */
  private String disputeTypeCode;

  /**
   * 需要排除的机构id
   */
  private Long excludeOrgId;

  /**
   * 机构id数组
   */
  private List<Long> orgIds;

  /**
   * 纠纷发生地等级
   */
  private String disputeAreaLevel;

  /**
   * 纠纷发生地代码
   */
  private String disputeAreaCode;

  /**
   * 纠纷发生地代码前两位（匹配省市）
   */
  private String disputeAreaCodeTwo;

  /**
   * 纠纷发生地代码前四位（匹配区县）
   */
  private String disputeAreaCodeFour;

  /**
   * 纠纷发生地代码前六位（匹配街道）
   */
  private String disputeAreaCodeSix;

  /**
   * 纠纷发生地代码前九位（匹配社区）
   */
  private String disputeAreaCodeNine;

  /**
   * 服务区域代码前两位（匹配省）
   */
  private String serviceAreaCodeTwo;

  /**
   * 服务区域代码前四位（匹配市）
   */
  private String serviceAreaCodeFour;

  /**
   * 服务区域代码前六位（匹配区）
   */
  private String serviceAreaCodeSix;

  /**
   * 服务区域代码前九位（匹配街道）
   */
  private String serviceAreaCodeNine;
  /**
   * 服务区域代码十二位（匹配社区）
   */
  private String serviceAreaCodeTwelve;

  /**
   * 当前登录用户id
   */
  private String currentUserId;

  /**
   * 备注
   */
  private String remark;

  /**
   * 社区地址代码
   */
  private String communityCode;
  /**
   * 街道地址代码
   */
  private String streetCode;
  /**
   * 其他街道代码
   */
  private String otherStreetCode;
  /**
   * 判断是否包括测试机构
   */
  private Boolean isNotTest = true; // 默认是true

  private Boolean isPublic = true; // 默认是true对群众公开
  /**
   * 通过传递的组织id，查询该机构和下面的所有机构信息
   */
  private Long fatherOrgId;
  /**
   * 查找的角色类型。类型值由前端进行判断。
   */
  private String orgRoleType;
  /**
   * 查找的角色列表。类型值由前端进行判断。
   */
  private List<String> orgRoleTypeList;
  /**
   * 是否是申请案子。
   */
  private Boolean applyCase = false;
  //发生地的数组
  private List<String> serviceAreaCodes;
  //通过地区排序
  private Boolean orderByArea = false;
  //通过机构等级排序
  private Boolean orderByOrgRoleType = false;

  /**
   * 系统当前登录用户的组织机构id
   */
  private List<Long> currentLoginUserOrgIds;
}
