package com.beiming.odr.user.api.dto.requestdto;

import com.beiming.framework.page.PageQuery;
import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class ServicePersonListReqDTO extends PageQuery implements Serializable {

  private static final long serialVersionUID = -3209068441805383190L;

  /**
   * 人员名称
   */
  private String userName;

  /**
   * 机构id
   */
  private Long orgId;

  /**
   * 查询组织机构id集合
   */
  private List<Long> queryOrgId;

  /**
   * 擅长领域
   */
  private String ability;

  /**
   * 调解方式
   */
  private String mediateCode;

  /**
   * 人员类型（调解员、咨询师、法官）
   */
  private String roleType;

  /**
   * 区域代码
   */
  private String areaCode;

  /**
   * 服务区域代码前两位（匹配省）
   */
  private String serviceAreaCodeTwo;

  /**
   * 服务区域代码前四位（匹配市）
   */
  private String serviceAreaCodeFour;

  /**
   * 服务区域代码前六位（匹配区）
   */
  private String serviceAreaCodeSix;

  /**
   * 服务区域代码前九位（匹配街道）
   */
  private String serviceAreaCodeNine;
  /**
   * 服务区域代码十二位（匹配社区）
   */
  private String serviceAreaCodeTwelve;

  /**
   * 当前登录用户id
   */
  private String currentUserId;

  /**
   * 备注
   */
  private String remark;

  /**
   * 关键字（用户名称或擅长领域）
   */
  private String keywords;

  private Boolean limitflag = true;

  /**
   * 需排除的id
   */
  private List<Long> excludeUserIds;

  /**
   * 列表类型 协助调解员列表 服务资源列表
   */
  private String listType;
  /**
   * 通过传递的组织id，查询该机构和下面的所有机构信息
   */
  private Long fatherOrgId;
  /**
   * 组织ids
   */
  private List<Long> orgIds;
  /**
   * 查看所有状态账号
   */
  private Boolean allStatus;
  /**
   * 指定状态 0 和 1
   */
  private Integer status;
}
